/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxReader;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class PartitionOverwriteControl {
    private static final Log LOG = LogFactory.getLog(PartitionOverwriteControl.class);
    ConcurrentHashMap<ObjList<ReaderPartitionUsage>> readerPartitionUsageMap = new ConcurrentHashMap();
    private boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquirePartitions(TableReader reader) {
        if (this.enabled) {
            ObjList usages;
            LOG.info().$("acquiring partitions [table=").$safe(reader.getTableToken().getTableName()).$(", readerTxn=").$(reader.getTxn()).I$();
            assert (reader.isActive());
            LongList partitions = new LongList();
            reader.dumpRawTxPartitionInfo(partitions);
            ReaderPartitionUsage readerPartitionUsage = new ReaderPartitionUsage();
            readerPartitionUsage.owner = reader;
            readerPartitionUsage.partitionsList = partitions;
            readerPartitionUsage.ownerTxn = reader.getTxn();
            ObjList objList = usages = this.readerPartitionUsageMap.computeIfAbsent(reader.getTableToken().getDirName(), k -> new ObjList());
            synchronized (objList) {
                int n = usages.size();
                for (int i = 0; i < n; ++i) {
                    ReaderPartitionUsage existing = (ReaderPartitionUsage)usages.get(i);
                    if (existing.owner != reader) continue;
                    return;
                }
                usages.add(readerPartitionUsage);
            }
        }
    }

    public void clear() {
        if (this.enabled) {
            this.readerPartitionUsageMap.clear();
        }
    }

    public void enable() {
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPartitionMutates(TableToken tableToken, long partitionTimestamp, long partitionNameTxn, long mutateFromRow) {
        ObjList<ReaderPartitionUsage> usages;
        if (this.enabled && (usages = this.readerPartitionUsageMap.get(tableToken.getDirName())) != null) {
            ObjList<ReaderPartitionUsage> objList = usages;
            synchronized (objList) {
                int n = usages.size();
                for (int i = 0; i < n; ++i) {
                    ReaderPartitionUsage readerPartitionUsage = usages.get(i);
                    int partitionBlockIndex = TxReader.findPartitionRawIndex(readerPartitionUsage.partitionsList, partitionTimestamp);
                    if (partitionBlockIndex < 0) continue;
                    long usedPartitionNameTxn = TxReader.getPartitionNameTxnByRawIndex(readerPartitionUsage.partitionsList, partitionBlockIndex);
                    long visibleRows = TxReader.getPartitionSizeByRawIndex(readerPartitionUsage.partitionsList, partitionBlockIndex);
                    if (usedPartitionNameTxn != partitionNameTxn || visibleRows <= mutateFromRow) continue;
                    throw CairoException.critical(0).put("partition is overwritten while being in use by a reader [table=").put(tableToken.getTableName()).put(", partition=").ts(partitionTimestamp).put(", partitionNameTxn=").put(partitionNameTxn).put(", readerTxn=").put(readerPartitionUsage.ownerTxn).put(", mutateFromRow=").put(mutateFromRow).put(", visibleRows=").put(visibleRows).put(']');
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePartitions(TableReader reader) {
        if (this.enabled) {
            LOG.info().$("releasing partitions [table=").$safe(reader.getTableToken().getTableName()).$(", readerTxn=").$(reader.getTxn()).I$();
            ObjList<ReaderPartitionUsage> usages = this.readerPartitionUsageMap.get(reader.getTableToken().getDirName());
            if (usages != null) {
                ObjList<ReaderPartitionUsage> objList = usages;
                synchronized (objList) {
                    int n = usages.size();
                    for (int i = 0; i < n; ++i) {
                        ReaderPartitionUsage readerPartitionUsage = usages.get(i);
                        if (readerPartitionUsage.owner != reader) continue;
                        usages.remove(i);
                        return;
                    }
                }
            }
            LOG.error().$("reader not found in partition usage map [table=").$safe(reader.getTableToken().getTableName()).$(", readerTxn=").$(reader.getTxn()).I$();
        }
    }

    private static class ReaderPartitionUsage {
        private TableReader owner;
        private long ownerTxn;
        private LongList partitionsList;

        private ReaderPartitionUsage() {
        }
    }
}

