/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.std.FilesFacade;
import io.questdb.std.Uuid;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public final class DataID
implements Sinkable {
    public static final CharSequence FILENAME = ".data_id";
    public static long FILE_SIZE = 128L;
    private final CairoConfiguration configuration;
    private final Uuid id;

    public DataID(CairoConfiguration configuration, Uuid id) {
        this.id = id;
        this.configuration = configuration;
    }

    public static DataID open(CairoConfiguration configuration) throws CairoException {
        long hi;
        long lo;
        try (MemoryCMARWImpl mem = DataID.openDataIDFile(configuration);){
            lo = mem.getLong(0L);
            hi = mem.getLong(8L);
            if (lo == 0L && hi == 0L) {
                hi = Long.MIN_VALUE;
                lo = Long.MIN_VALUE;
            }
        }
        return new DataID(configuration, new Uuid(lo, hi));
    }

    public long getHi() {
        return this.id.getHi();
    }

    public long getLo() {
        return this.id.getLo();
    }

    public boolean isInitialized() {
        return !Uuid.isNull(this.id.getLo(), this.id.getHi());
    }

    public void set(long lo, long hi) {
        if (lo == this.id.getLo() && hi == this.id.getHi()) {
            return;
        }
        try (MemoryCMARWImpl mem = DataID.openDataIDFile(this.configuration);){
            mem.putLong(lo);
            mem.putLong(hi);
            mem.sync(false);
        }
        this.id.of(lo, hi);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        this.id.toSink(sink);
    }

    private static MemoryCMARWImpl openDataIDFile(CairoConfiguration configuration) {
        try (Path path = new Path();){
            path.of(configuration.getDbRoot());
            path.concat(FILENAME);
            FilesFacade ff = configuration.getFilesFacade();
            MemoryCMARWImpl memoryCMARWImpl = new MemoryCMARWImpl(ff, path.$(), FILE_SIZE, -1L, 0, configuration.getWriterFileOpenOpts());
            return memoryCMARWImpl;
        }
    }
}

