/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnPurgeTask;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class ColumnPurgeOperator
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ColumnPurgeOperator.class);
    private final LongList completedRowIds = new LongList();
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final MicrosecondClock microClock;
    private final Path path;
    private final int pathRootLen;
    private final TableWriter purgeLogWriter;
    private final ScoreboardUseMode scoreboardUseMode;
    private final String updateCompleteColumnName;
    private final int updateCompleteColumnWriterIndex;
    private long longBytes;
    private int pathTableLen;
    private long purgeLogPartitionFd = -1L;
    private long purgeLogPartitionTimestamp = Long.MAX_VALUE;
    private TxReader txReader;
    private TxnScoreboard txnScoreboard;

    public ColumnPurgeOperator(CairoEngine engine, TableWriter purgeLogWriter, String updateCompleteColumnName, ScoreboardUseMode scoreboardUseMode) {
        try {
            this.engine = engine;
            CairoConfiguration configuration = engine.getConfiguration();
            this.ff = configuration.getFilesFacade();
            this.path = new Path(255, 54);
            this.path.of(configuration.getDbRoot());
            this.pathRootLen = this.path.size();
            this.purgeLogWriter = purgeLogWriter;
            this.updateCompleteColumnName = updateCompleteColumnName;
            this.updateCompleteColumnWriterIndex = purgeLogWriter.getMetadata().getColumnIndex(updateCompleteColumnName);
            this.txReader = new TxReader(this.ff);
            this.microClock = configuration.getMicrosecondClock();
            this.longBytes = Unsafe.malloc(8L, 54);
            this.scoreboardUseMode = scoreboardUseMode;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public ColumnPurgeOperator(CairoEngine engine) {
        try {
            this.engine = engine;
            CairoConfiguration configuration = engine.getConfiguration();
            this.ff = configuration.getFilesFacade();
            this.path = new Path(255, 54);
            this.path.of(configuration.getDbRoot());
            this.pathRootLen = this.path.size();
            this.purgeLogWriter = null;
            this.updateCompleteColumnName = null;
            this.updateCompleteColumnWriterIndex = -1;
            this.txnScoreboard = null;
            this.txReader = null;
            this.microClock = configuration.getMicrosecondClock();
            this.longBytes = 0L;
            this.scoreboardUseMode = ScoreboardUseMode.VACUUM_TABLE;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        if (this.longBytes != 0L) {
            Unsafe.free(this.longBytes, 8L, 54);
            this.longBytes = 0L;
        }
        this.closePurgeLogCompleteFile();
        Misc.free(this.path);
        this.txnScoreboard = Misc.free(this.txnScoreboard);
    }

    public boolean purge(@NotNull ColumnPurgeTask task) {
        assert (task.getTableName() != null);
        assert (this.scoreboardUseMode != ScoreboardUseMode.VACUUM_TABLE);
        boolean done = this.purge0(task);
        if (done && this.scoreboardUseMode == ScoreboardUseMode.BAU_QUEUE_PROCESSING) {
            this.setCompletionTimestamp(this.completedRowIds, this.microClock.getTicks());
        }
        return done;
    }

    public boolean purge(@NotNull ColumnPurgeTask task, @NotNull TableReader tableReader) {
        assert (task.getTableName() != null);
        assert (this.scoreboardUseMode == ScoreboardUseMode.VACUUM_TABLE);
        this.txReader = tableReader.getTxFile();
        this.txnScoreboard = tableReader.getTxnScoreboard();
        return this.purge0(task);
    }

    private static boolean couldNotRemove(FilesFacade ff, LPSZ path) {
        if (ff.removeQuiet(path)) {
            return false;
        }
        int errno = ff.errno();
        if (ff.exists(path)) {
            LOG.info().$("cannot delete file, will retry [path=").$(path).$(", errno=").$(errno).I$();
            return true;
        }
        return false;
    }

    private boolean checkScoreboardHasReadersBeforeUpdate(long columnVersion, ColumnPurgeTask task) {
        long updateTxn = task.getUpdateTxn();
        try {
            return !this.txnScoreboard.isRangeAvailable(columnVersion + 1L, updateTxn);
        }
        catch (CairoException ex) {
            LOG.error().$("cannot lock last txn in scoreboard, column purge will re-run [table=").$safe(task.getTableName().getTableName()).$(", txn=").$(updateTxn).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return true;
        }
    }

    private void closePurgeLogCompleteFile() {
        if (this.ff.close(this.purgeLogPartitionFd)) {
            LOG.info().$("closed purge log complete file [fd=").$(this.purgeLogPartitionFd).I$();
            this.purgeLogPartitionFd = -1L;
        }
    }

    private boolean openScoreboardAndTxn(ColumnPurgeTask task) {
        switch (this.scoreboardUseMode) {
            case BAU_QUEUE_PROCESSING: {
                this.txnScoreboard = Misc.free(this.txnScoreboard);
                this.txnScoreboard = this.engine.getTxnScoreboard(task.getTableName());
            }
            case STARTUP_ONLY: {
                int tableId = this.readTableId(this.path);
                if (tableId != task.getTableId()) {
                    LOG.info().$("cannot purge orphan table [path=").$(this.path.trimTo(this.pathTableLen)).I$();
                    return false;
                }
                this.path.trimTo(this.pathTableLen).concat("_txn");
                this.txReader.ofRO(this.path.$(), task.getPartitionBy());
                this.txReader.unsafeLoadAll();
                if (this.txReader.getTruncateVersion() != task.getTruncateVersion()) {
                    LOG.info().$("cannot purge, purge request overlaps with truncate [path=").$(this.path.trimTo(this.pathTableLen)).I$();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean purge0(ColumnPurgeTask task) {
        try {
            this.setTablePath(task.getTableName());
            LongList updatedColumnInfo = task.getUpdatedColumnInfo();
            long minUnlockedTxnRangeStarts = Long.MAX_VALUE;
            boolean allDone = true;
            boolean setupScoreboard = this.scoreboardUseMode != ScoreboardUseMode.VACUUM_TABLE;
            try {
                this.completedRowIds.clear();
                int n = updatedColumnInfo.size();
                for (int i = 0; i < n; i += 4) {
                    int pathTrimToPartition;
                    long columnVersion = updatedColumnInfo.getQuick(i + 0);
                    long partitionTimestamp = updatedColumnInfo.getQuick(i + 1);
                    long partitionTxnName = updatedColumnInfo.getQuick(i + 2);
                    long updateRowId = updatedColumnInfo.getQuick(i + 3);
                    int columnTypeRaw = task.getColumnType();
                    int columnType = Math.abs(columnTypeRaw);
                    boolean columnTypeRogue = columnTypeRaw == 0;
                    boolean isSymbolRootFiles = (ColumnType.isSymbol(columnType) || columnTypeRogue) && partitionTimestamp == -9223372036854775807L;
                    CharSequence columnName = task.getColumnName();
                    if (!isSymbolRootFiles) {
                        this.setUpPartitionPath(task.getPartitionBy(), partitionTimestamp, partitionTxnName);
                        pathTrimToPartition = this.path.size();
                        TableUtils.dFile(this.path, columnName, columnVersion);
                    } else {
                        this.path.trimTo(this.pathTableLen);
                        pathTrimToPartition = this.path.size();
                        TableUtils.charFileName(this.path, columnName, columnVersion);
                    }
                    if (!this.ff.exists(this.path.$()) && !columnTypeRogue) {
                        if (ColumnType.isVarSize(columnType)) {
                            this.path.trimTo(pathTrimToPartition);
                            if (!this.ff.exists(TableUtils.iFile(this.path, columnName, columnVersion))) {
                                this.completedRowIds.add(updateRowId);
                                continue;
                            }
                        } else if (ColumnType.isSymbol(columnType)) {
                            if (!(this.ff.exists(TableUtils.offsetFileName(this.path.trimTo(pathTrimToPartition), columnName, columnVersion)) || this.ff.exists(BitmapIndexUtils.keyFileName(this.path.trimTo(pathTrimToPartition), columnName, columnVersion)) || this.ff.exists(BitmapIndexUtils.valueFileName(this.path.trimTo(pathTrimToPartition), columnName, columnVersion)))) {
                                this.completedRowIds.add(updateRowId);
                                continue;
                            }
                        } else {
                            this.completedRowIds.add(updateRowId);
                            continue;
                        }
                    }
                    if (setupScoreboard) {
                        if (!this.openScoreboardAndTxn(task)) {
                            this.completedRowIds.add(updateRowId);
                            continue;
                        }
                        if (!isSymbolRootFiles) {
                            this.setUpPartitionPath(task.getPartitionBy(), partitionTimestamp, partitionTxnName);
                        } else {
                            this.path.trimTo(this.pathTableLen);
                        }
                        pathTrimToPartition = this.path.size();
                        TableUtils.dFile(this.path, columnName, columnVersion);
                        setupScoreboard = false;
                    }
                    if (this.txReader.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
                        LOG.info().$("skipping purge of read-only partition [path=").$(this.path.$()).$(", column=").$safe(columnName).I$();
                        this.completedRowIds.add(updateRowId);
                        continue;
                    }
                    if (columnVersion < minUnlockedTxnRangeStarts) {
                        if (this.scoreboardUseMode != ScoreboardUseMode.STARTUP_ONLY && this.checkScoreboardHasReadersBeforeUpdate(columnVersion, task)) {
                            allDone = false;
                            LOG.debug().$("cannot purge, version is in use [path=").$(this.path).I$();
                            continue;
                        }
                        minUnlockedTxnRangeStarts = columnVersion;
                    }
                    LOG.info().$("purging [path=").$(this.path).I$();
                    if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path.$())) {
                        allDone = false;
                        continue;
                    }
                    if (ColumnType.isVarSize(columnType) || columnTypeRogue) {
                        this.path.trimTo(pathTrimToPartition);
                        TableUtils.iFile(this.path, columnName, columnVersion);
                        if (ColumnPurgeOperator.couldNotRemove(this.ff, this.path.$())) {
                            allDone = false;
                            continue;
                        }
                    }
                    if (ColumnType.isSymbol(columnType) || columnTypeRogue) {
                        if (isSymbolRootFiles) {
                            this.path.trimTo(pathTrimToPartition);
                            if (ColumnPurgeOperator.couldNotRemove(this.ff, TableUtils.charFileName(this.path, columnName, columnVersion))) {
                                allDone = false;
                                continue;
                            }
                            this.path.trimTo(pathTrimToPartition);
                            if (ColumnPurgeOperator.couldNotRemove(this.ff, TableUtils.offsetFileName(this.path, columnName, columnVersion))) {
                                allDone = false;
                                continue;
                            }
                        }
                        this.path.trimTo(pathTrimToPartition);
                        if (ColumnPurgeOperator.couldNotRemove(this.ff, BitmapIndexUtils.keyFileName(this.path, columnName, columnVersion))) {
                            allDone = false;
                            continue;
                        }
                        this.path.trimTo(pathTrimToPartition);
                        if (ColumnPurgeOperator.couldNotRemove(this.ff, BitmapIndexUtils.valueFileName(this.path, columnName, columnVersion))) {
                            allDone = false;
                            continue;
                        }
                    }
                    this.completedRowIds.add(updateRowId);
                }
            }
            finally {
                if (this.scoreboardUseMode != ScoreboardUseMode.VACUUM_TABLE) {
                    this.txnScoreboard = Misc.free(this.txnScoreboard);
                    Misc.free(this.txReader);
                } else {
                    this.txnScoreboard = null;
                    this.txReader = null;
                }
            }
            return allDone;
        }
        catch (Throwable e) {
            LOG.error().$("could not purge [ex=`").$(e).$("`]").$();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTableId(Path path) {
        int INVALID_TABLE_ID = Integer.MIN_VALUE;
        long fd = this.ff.openRO(path.trimTo(this.pathTableLen).concat("_meta").$());
        if (fd < 0L) {
            return Integer.MIN_VALUE;
        }
        try {
            if (this.ff.read(fd, this.longBytes, 4L, 16L) != 4L) {
                int n = Integer.MIN_VALUE;
                return n;
            }
            int n = Unsafe.getUnsafe().getInt(this.longBytes);
            return n;
        }
        finally {
            this.ff.close(fd);
        }
    }

    private void reopenPurgeLogPartition(int partitionIndex, long partitionTimestamp) {
        this.path.trimTo(this.pathRootLen);
        this.path.concat(this.purgeLogWriter.getTableToken());
        long partitionNameTxn = this.purgeLogWriter.getPartitionNameTxn(partitionIndex);
        TableUtils.setPathForNativePartition(this.path, this.purgeLogWriter.getPartitionBy(), partitionTimestamp, partitionNameTxn);
        TableUtils.dFile(this.path, this.updateCompleteColumnName, this.purgeLogWriter.getColumnNameTxn(partitionTimestamp, this.updateCompleteColumnWriterIndex));
        this.closePurgeLogCompleteFile();
        this.purgeLogPartitionFd = TableUtils.openRW(this.ff, this.path.$(), LOG, this.purgeLogWriter.getConfiguration().getWriterFileOpenOpts());
        this.purgeLogPartitionTimestamp = partitionTimestamp;
        LOG.info().$("reopened purge log complete file [path=").$(this.path).$(", fd=").$(this.purgeLogPartitionFd).I$();
    }

    private void setCompletionTimestamp(LongList completedRecordIds, long timeMicro) {
        try {
            Unsafe.getUnsafe().putLong(this.longBytes, timeMicro);
            int n = completedRecordIds.size();
            for (int rec = 0; rec < n; ++rec) {
                long partitionTimestamp;
                long recordId = completedRecordIds.getQuick(rec);
                int partitionIndex = Rows.toPartitionIndex(recordId);
                if (rec == 0 && this.purgeLogPartitionTimestamp != (partitionTimestamp = this.purgeLogWriter.getPartitionTimestamp(partitionIndex))) {
                    this.reopenPurgeLogPartition(partitionIndex, partitionTimestamp);
                }
                long rowId = Rows.toLocalRowID(recordId);
                long offset = rowId * 8L;
                if (this.ff.write(this.purgeLogPartitionFd, this.longBytes, 8L, rowId * 8L) == 8L) continue;
                int errno = this.ff.errno();
                long length = this.ff.length(this.purgeLogPartitionFd);
                LOG.error().$("could not mark record as purged [errno=").$(errno).$(", writeOffset=").$(offset).$(", fd=").$(this.purgeLogPartitionFd).$(", fileSize=").$(length).I$();
                this.purgeLogPartitionTimestamp = -1L;
            }
        }
        catch (CairoException ex) {
            LOG.error().$("could not update completion timestamp").$(ex).$();
        }
    }

    private void setTablePath(TableToken tableName) {
        this.path.trimTo(this.pathRootLen).concat(tableName);
        this.pathTableLen = this.path.size();
    }

    private void setUpPartitionPath(int partitionBy, long partitionTimestamp, long partitionTxnName) {
        this.path.trimTo(this.pathTableLen);
        TableUtils.setPathForNativePartition(this.path, partitionBy, partitionTimestamp, partitionTxnName);
    }

    public static enum ScoreboardUseMode {
        BAU_QUEUE_PROCESSING,
        VACUUM_TABLE,
        STARTUP_ONLY;

    }
}

