/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.StringTypeDriver;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class BinaryTypeDriver
extends StringTypeDriver {
    public static final BinaryTypeDriver INSTANCE = new BinaryTypeDriver();

    @Override
    public void appendNull(MemoryA auxMem, MemoryA dataMem) {
        auxMem.putLong(dataMem.putNullBin());
    }

    @Override
    public long getDataVectorMinEntrySize() {
        return 8L;
    }

    @Override
    public boolean isSparseDataVector(long auxMemAddr, long dataMemAddr, long rowCount) {
        int row = 0;
        while ((long)row < rowCount) {
            long dStorageLen;
            long offset = Unsafe.getUnsafe().getLong(auxMemAddr + (long)row * 8L);
            long iLen = Unsafe.getUnsafe().getLong(auxMemAddr + (long)(row + 1) * 8L) - offset;
            long dLen = Unsafe.getUnsafe().getLong(dataMemAddr + offset);
            int lenLen = 8;
            long l = dStorageLen = dLen > 0L ? dLen + (long)lenLen : (long)lenLen;
            if (iLen != dStorageLen) {
                return true;
            }
            ++row;
        }
        return false;
    }

    @Override
    public void o3ColumnMerge(long timestampMergeIndexAddr, long timestampMergeIndexCount, long srcAuxAddr1, long srcDataAddr1, long srcAuxAddr2, long srcDataAddr2, long dstAuxAddr, long dstDataAddr, long dstDataOffset) {
        Vect.oooMergeCopyBinColumn(timestampMergeIndexAddr, timestampMergeIndexCount, srcAuxAddr1, srcDataAddr1, srcAuxAddr2, srcDataAddr2, dstAuxAddr, dstDataAddr, dstDataOffset);
    }

    @Override
    public void setDataVectorEntriesToNull(long dataMemAddr, long rowCount) {
        Vect.memset(dataMemAddr, rowCount * 8L, -1);
    }

    @Override
    public void setFullAuxVectorNull(long auxMemAddr, long rowCount) {
        Vect.setBinaryColumnNullRefs(auxMemAddr, 0L, rowCount + 1L);
    }

    @Override
    public void setPartAuxVectorNull(long auxMemAddr, long initialOffset, long columnTop) {
        Vect.setBinaryColumnNullRefs(auxMemAddr, initialOffset, columnTop);
    }
}

