/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BootstrapConfiguration;
import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.DefaultFactoryProvider;
import io.questdb.DynamicPropServerConfiguration;
import io.questdb.MemoryConfiguration;
import io.questdb.PropBootstrapConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.ServerMain;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableUtils;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.griffin.engine.functions.str.SizePrettyFunctionFactory;
import io.questdb.jit.JitUtil;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecord;
import io.questdb.network.Net;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.str.DirectUtf8StringZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import sun.misc.Signal;

public class Bootstrap {
    public static final String CONFIG_FILE = "/server.conf";
    public static final String CONTAINERIZED_SYSTEM_PROPERTY = "containerized";
    public static final String SWITCH_USE_DEFAULT_LOG_FACTORY_CONFIGURATION = "--use-default-log-factory-configuration";
    private static final String LOG_NAME = "server-main";
    private static final String PUBLIC_VERSION_TXT = "version.txt";
    private static final String PUBLIC_ZIP = "/io/questdb/site/public.zip";
    private final String banner;
    private final BuildInformation buildInformation;
    private final ServerConfiguration config;
    private final Log log;
    private final MicrosecondClock microsecondClock;
    private final String rootDirectory;

    public Bootstrap(String ... args) {
        this(new PropBootstrapConfiguration(), args);
    }

    public Bootstrap(BootstrapConfiguration bootstrapConfiguration, String ... args) {
        if (args.length < 2) {
            throw new BootstrapException("Root directory name expected (-d <root-path>)");
        }
        Os.init();
        this.banner = bootstrapConfiguration.getBanner();
        this.microsecondClock = bootstrapConfiguration.getMicrosecondClock();
        this.buildInformation = new BuildInformationHolder(bootstrapConfiguration.getClass());
        CharSequenceObjHashMap<String> argsMap = Bootstrap.processArgs(args);
        this.rootDirectory = argsMap.get("-d");
        if (Chars.isBlank(this.rootDirectory)) {
            throw new BootstrapException("Root directory name expected (-d <root-path>)");
        }
        File rootPath = new File(this.rootDirectory);
        if (!rootPath.exists()) {
            throw new BootstrapException("Root directory does not exist: " + this.rootDirectory);
        }
        if (argsMap.get("-n") == null && Os.type != 3) {
            Signal.handle(new Signal("HUP"), signal -> {});
        }
        byte[] buffer = new byte[0x100000];
        try {
            this.copyLogConfResource(buffer);
        }
        catch (IOException e) {
            throw new BootstrapException("Could not extract log configuration file");
        }
        if (argsMap.get(SWITCH_USE_DEFAULT_LOG_FACTORY_CONFIGURATION) == null) {
            LogFactory.configureRootDir(this.rootDirectory);
        }
        this.log = LogFactory.getLog(LOG_NAME);
        try {
            Bootstrap.copyResource(this.rootDirectory, false, buffer, "import/readme.txt", this.log);
            Bootstrap.copyResource(this.rootDirectory, false, buffer, "import/trades.parquet", this.log);
        }
        catch (IOException e) {
            throw new BootstrapException("Could not create the default import directory");
        }
        this.log.advisoryW().$(this.buildInformation.getSwName()).$(' ').$(this.buildInformation.getSwVersion()).$(". Copyright (C) 2014-").$(Dates.getYear(System.currentTimeMillis())).$(", all rights reserved.").$();
        boolean isOsSupported = true;
        switch (Os.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                isOsSupported = false;
            }
        }
        StringBuilder sb = new StringBuilder(Vect.getSupportedInstructionSetName());
        sb.setLength(sb.length() - 1);
        sb.append(", ").append(System.getProperty("sun.arch.data.model")).append(" bits");
        sb.append(", ").append(Runtime.getRuntime().availableProcessors()).append(" processors");
        if (isOsSupported) {
            this.log.advisoryW().$(Os.name).$('-').$(Os.archName).$(sb).I$();
        } else {
            this.log.critical().$("!!UNSUPPORTED!!").$(System.getProperty("os.name")).$('-').$(Os.archName).$(sb).I$();
        }
        this.verifyFileLimits();
        try {
            ServerConfiguration configuration;
            if (bootstrapConfiguration.useSite()) {
                this.extractSite();
            }
            if ((configuration = bootstrapConfiguration.getServerConfiguration(this)) == null) {
                Properties properties = this.loadProperties();
                FilesFacade ffOverride = bootstrapConfiguration.getFilesFacade();
                this.config = ffOverride == null ? new DynamicPropServerConfiguration(this.rootDirectory, properties, bootstrapConfiguration.getEnv(), this.log, this.buildInformation) : new DynamicPropServerConfiguration(this.rootDirectory, properties, bootstrapConfiguration.getEnv(), this.log, this.buildInformation, ffOverride, MicrosecondClockImpl.INSTANCE, (configuration1, engine, freeOnExit) -> DefaultFactoryProvider.INSTANCE, true);
            } else {
                this.config = configuration;
            }
            Files.FS_CACHE_ENABLED = this.config.getCairoConfiguration().getFileDescriptorCacheEnabled();
            LogLevel.init(this.config.getCairoConfiguration());
            if (LogLevel.TIMESTAMP_TIMEZONE != null) {
                this.log.infoW().$("changing logger timezone [from=`UTC`, to=`").$(LogLevel.TIMESTAMP_TIMEZONE).$('`').I$();
            }
            this.reportValidateConfig();
            Bootstrap.reportCrashFiles(this.config.getCairoConfiguration(), this.log);
        }
        catch (BootstrapException e) {
            throw e;
        }
        catch (ServerConfigurationException e) {
            throw new BootstrapException(e);
        }
        catch (Throwable e) {
            this.log.errorW().$(e).$();
            throw new BootstrapException(e);
        }
        if (!this.config.getMetricsConfiguration().isEnabled()) {
            this.log.advisoryW().$("Metrics are disabled, health check endpoint will not consider unhandled errors").$();
        }
        Unsafe.setRssMemLimit(this.config.getMemoryConfiguration().getResolvedRamUsageLimitBytes());
    }

    public static String[] getServerMainArgs(CharSequence root) {
        return new String[]{"-d", Chars.toString(root), SWITCH_USE_DEFAULT_LOG_FACTORY_CONFIGURATION};
    }

    public static CharSequenceObjHashMap<String> processArgs(String ... args) {
        int n = args.length;
        if (n == 0) {
            throw new BootstrapException("Arguments expected, non provided");
        }
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        for (int i = 0; i < n; ++i) {
            String arg = args[i];
            if (arg.length() > 1 && arg.charAt(0) == '-') {
                if (i + 1 < n) {
                    String nextArg = args[i + 1];
                    if (nextArg.length() > 1 && nextArg.charAt(0) == '-') {
                        optHash.put(arg, "");
                        continue;
                    }
                    optHash.put(arg, nextArg);
                    ++i;
                    continue;
                }
                optHash.put(arg, "");
                continue;
            }
            optHash.put("$" + i, arg);
        }
        return optHash;
    }

    public static void reportCrashFiles(CairoConfiguration cairoConfiguration, Log log) {
        String dbRoot = cairoConfiguration.getDbRoot();
        FilesFacade ff = cairoConfiguration.getFilesFacade();
        int maxFiles = cairoConfiguration.getMaxCrashFiles();
        DirectUtf8StringZ name = new DirectUtf8StringZ();
        try (Path path = new Path();
             Path other = new Path();){
            path.of(dbRoot).slash();
            other.of(dbRoot).slash();
            int plen = path.size();
            AtomicInteger counter = new AtomicInteger(0);
            FilesFacadeImpl.INSTANCE.iterateDir(path.$(), (pUtf8NameZ, type) -> {
                if (Files.notDots(pUtf8NameZ)) {
                    name.of(pUtf8NameZ);
                    if (Utf8s.startsWithAscii(name, cairoConfiguration.getOGCrashFilePrefix()) && type == 8) {
                        path.trimTo(plen).concat(pUtf8NameZ).$();
                        boolean shouldRename = false;
                        do {
                            other.trimTo(plen).concat(cairoConfiguration.getArchivedCrashFilePrefix()).put(counter.getAndIncrement()).put(".log").$();
                            if (ff.exists(other.$())) continue;
                            shouldRename = counter.get() <= maxFiles;
                            break;
                        } while (counter.get() < maxFiles);
                        if (shouldRename && ff.rename(path.$(), other.$()) == 0) {
                            log.critical().$("found crash file [path=").$(other).I$();
                        } else {
                            log.critical().$("could not rename crash file [path=").$(path).$(", errno=").$(ff.errno()).$(", index=").$(counter.get()).$(", max=").$(maxFiles).I$();
                        }
                    }
                }
            });
        }
    }

    public void extractSite() throws IOException {
        byte[] buffer = new byte[0x100000];
        URL resource = ServerMain.class.getResource(PUBLIC_ZIP);
        if (resource == null) {
            this.log.infoW().$("Web Console build [").$(PUBLIC_ZIP).$("] not found").$();
            this.extractConfDir(buffer);
        } else {
            long thisVersion = resource.openConnection().getLastModified();
            String publicDir = this.rootDirectory + Files.SEPARATOR + "public";
            boolean extracted = false;
            String oldSwVersion = Bootstrap.getPublicVersion(publicDir);
            String newSwVersion = this.buildInformation.getSwVersion();
            if (oldSwVersion == null) {
                if (thisVersion != 0L) {
                    this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                } else {
                    this.extractSite0(publicDir, buffer, Chars.toString(newSwVersion));
                }
                extracted = true;
            } else if (thisVersion == 0L) {
                if (!Chars.equals((CharSequence)oldSwVersion, (CharSequence)newSwVersion)) {
                    this.extractSite0(publicDir, buffer, Chars.toString(newSwVersion));
                    extracted = true;
                }
            } else {
                try {
                    long oldVersion = Numbers.parseLong(oldSwVersion);
                    if (thisVersion > oldVersion) {
                        this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                        extracted = true;
                    }
                }
                catch (NumericException e) {
                    this.extractSite0(publicDir, buffer, Long.toString(thisVersion));
                    extracted = true;
                }
            }
            if (!extracted) {
                this.log.infoW().$("Web Console is up to date").$();
            }
        }
    }

    public BuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    public ServerConfiguration getConfiguration() {
        return this.config;
    }

    public Log getLog() {
        return this.log;
    }

    public MicrosecondClock getMicrosecondClock() {
        return this.microsecondClock;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        java.nio.file.Path configFile = Paths.get(this.rootDirectory, "conf", CONFIG_FILE);
        this.log.advisoryW().$("Server config: ").$(configFile).$();
        if (!java.nio.file.Files.exists(configFile, new LinkOption[0])) {
            throw new BootstrapException("Server configuration file does not exist! " + String.valueOf(configFile), true);
        }
        if (!java.nio.file.Files.isReadable(configFile)) {
            throw new BootstrapException("Server configuration file exists, but is not readable! Check file permissions. " + String.valueOf(configFile), true);
        }
        try (InputStream is = java.nio.file.Files.newInputStream(configFile, new OpenOption[0]);){
            properties.load(is);
        }
        return properties;
    }

    public CairoEngine newCairoEngine() {
        return new CairoEngine(this.getConfiguration().getCairoConfiguration());
    }

    private static void copyInputStream(boolean force, byte[] buffer, File out, InputStream is, Log log) throws IOException {
        boolean exists = out.exists();
        if (force || !exists) {
            File dir = out.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                if (log != null) {
                    log.errorW().$("could not create directory [path=").$(dir).I$();
                }
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(out);){
                int n;
                while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, n);
                }
            }
            if (log != null) {
                log.infoW().$("extracted [path=").$(out).I$();
            }
            return;
        }
        if (log != null) {
            log.debugW().$("skipped [path=").$(out).I$();
        }
    }

    private static void copyResource(String dir, boolean force, byte[] buffer, String res, String dest, Log log) throws IOException {
        File out = new File(dir, dest);
        try (InputStream is = ServerMain.class.getResourceAsStream("/io/questdb/site/" + res);){
            if (is != null) {
                Bootstrap.copyInputStream(force, buffer, out, is, log);
            }
        }
    }

    private static void copyResource(String dir, boolean force, byte[] buffer, String res, Log log) throws IOException {
        Bootstrap.copyResource(dir, force, buffer, res, res, log);
    }

    private static String getPublicVersion(String publicDir) throws IOException {
        File f = new File(publicDir, PUBLIC_VERSION_TXT);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                byte[] buf = new byte[128];
                int len = fis.read(buf);
                String string = new String(buf, 0, len);
                return string;
            }
        }
        return null;
    }

    private static void padToNextCol(StringBuilder sb, int headerWidth) {
        int colWidth = 32;
        sb.append("  ");
        for (int i = headerWidth + 2; i < colWidth; ++i) {
            sb.append(' ');
        }
    }

    private static void setPublicVersion(String publicDir, String version) throws IOException {
        File f = new File(publicDir, PUBLIC_VERSION_TXT);
        File publicFolder = f.getParentFile();
        if (!publicFolder.exists() && !publicFolder.mkdirs()) {
            throw new BootstrapException("Cannot create folder: " + String.valueOf(publicFolder));
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            byte[] buf = version.getBytes();
            fos.write(buf, 0, buf.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyFileOpts(Path path, CairoConfiguration cairoConfiguration) {
        FilesFacade ff;
        block6: {
            ff = cairoConfiguration.getFilesFacade();
            path.of(cairoConfiguration.getDbRoot()).concat("_verify_").put(cairoConfiguration.getRandom().nextPositiveInt()).put(".d").$();
            long fd = ff.openRW(path.$(), cairoConfiguration.getWriterFileOpenOpts());
            try {
                if (fd <= -1L) break block6;
                long mem = Unsafe.malloc(8L, 19);
                try {
                    TableUtils.writeLongOrFail(ff, fd, 0L, 123456789L, mem, path);
                }
                finally {
                    Unsafe.free(mem, 8L, 19);
                }
            }
            finally {
                ff.close(fd);
            }
        }
        ff.remove(path.$());
    }

    private void copyLogConfResource(byte[] buffer) throws IOException {
        if (Chars.equalsIgnoreCaseNc("false", System.getProperty(CONTAINERIZED_SYSTEM_PROPERTY))) {
            Bootstrap.copyResource(this.rootDirectory, false, buffer, "conf/non_containerized_log.conf", "conf/log.conf", null);
        } else {
            Bootstrap.copyResource(this.rootDirectory, false, buffer, "conf/log.conf", null);
        }
    }

    private void createHelloFile(String helloMsg) {
        File helloFile = new File(this.rootDirectory, "hello.txt");
        File growingFile = new File(this.rootDirectory, helloFile.getName() + ".tmp");
        try (FileWriter w = new FileWriter(growingFile);){
            w.write(helloMsg);
        }
        catch (IOException e) {
            this.log.infoW().$("Failed to create ").$(growingFile.getAbsolutePath()).$();
        }
        if (!growingFile.renameTo(helloFile)) {
            this.log.infoW().$("Failed to rename ").$(growingFile.getAbsolutePath()).$(" to ").$(helloFile.getName()).$();
        }
        helloFile.deleteOnExit();
    }

    private void extractConfDir(byte[] buffer) throws IOException {
        block2: {
            Bootstrap.copyResource(this.rootDirectory, false, buffer, "conf/date.formats", this.log);
            try {
                Bootstrap.copyResource(this.rootDirectory, true, buffer, "conf/mime.types", this.log);
            }
            catch (IOException exception) {
                if (exception.getMessage() != null && (exception.getMessage().contains("Read-only file system") || exception.getMessage().contains("Permission denied"))) break block2;
                throw exception;
            }
        }
        Bootstrap.copyResource(this.rootDirectory, false, buffer, "conf/server.conf", this.log);
        this.copyLogConfResource(buffer);
    }

    private void extractSite0(String publicDir, byte[] buffer, String thisVersion) throws IOException {
        block14: {
            try (InputStream is = ServerMain.class.getResourceAsStream(PUBLIC_ZIP);){
                if (is != null) {
                    try (ZipInputStream zip = new ZipInputStream(is);){
                        ZipEntry ze;
                        while ((ze = zip.getNextEntry()) != null) {
                            File dest = new File(publicDir, ze.getName());
                            if (!ze.isDirectory()) {
                                Bootstrap.copyInputStream(true, buffer, dest, zip, this.log);
                            }
                            zip.closeEntry();
                        }
                        break block14;
                    }
                }
                this.log.errorW().$("could not find site [resource=").$(PUBLIC_ZIP).$(']').$();
            }
        }
        Bootstrap.setPublicVersion(publicDir, thisVersion);
        this.extractConfDir(buffer);
    }

    private void reportValidateConfig() {
        boolean httpEnabled = this.config.getHttpServerConfiguration().isEnabled();
        boolean httpReadOnly = this.config.getHttpServerConfiguration().getHttpContextConfiguration().readOnlySecurityContext();
        String httpReadOnlyHint = httpEnabled && httpReadOnly ? " [read-only]" : "";
        boolean pgEnabled = this.config.getPGWireConfiguration().isEnabled();
        boolean pgReadOnly = this.config.getPGWireConfiguration().readOnlySecurityContext();
        String pgReadOnlyHint = pgEnabled && pgReadOnly ? " [read-only]" : "";
        CairoConfiguration cairoConfig = this.config.getCairoConfiguration();
        this.log.advisoryW().$("Config:").$();
        this.log.advisoryW().$(" - http.enabled : ").$(httpEnabled).$(httpReadOnlyHint).$();
        boolean enabled = this.config.getLineTcpReceiverConfiguration().isEnabled();
        this.log.advisoryW().$(" - tcp.enabled  : ").$(enabled).$();
        this.log.advisoryW().$(" - pg.enabled   : ").$(pgEnabled).$(pgReadOnlyHint).$();
        if (cairoConfig != null) {
            this.log.advisoryW().$(" - attach partition suffix: ").$(cairoConfig.getAttachPartitionSuffix()).$();
            this.log.advisoryW().$(" - open database [").$uuid(cairoConfig.getDatabaseIdLo(), cairoConfig.getDatabaseIdHi()).I$();
            if (cairoConfig.isReadOnlyInstance()) {
                this.log.advisoryW().$(" - THIS IS READ ONLY INSTANCE").$();
            }
            try (Path path = new Path();){
                this.verifyFileSystem(path, cairoConfig.getDbRoot(), "db", true, true);
                this.verifyFileSystem(path, cairoConfig.getBackupRoot(), "backup", false, false);
                this.verifyFileSystem(path, cairoConfig.getCheckpointRoot(), ".checkpoint", true, false);
                this.verifyFileSystem(path, cairoConfig.getLegacyCheckpointRoot(), "snapshot", false, false);
                this.verifyFileSystem(path, cairoConfig.getSqlCopyInputRoot(), "sql copy input", false, false);
                this.verifyFileSystem(path, cairoConfig.getSqlCopyInputWorkRoot(), "sql copy input worker", true, false);
                Bootstrap.verifyFileOpts(path, cairoConfig);
                cairoConfig.getVolumeDefinitions().forEach((alias, volumePath) -> this.verifyFileSystem(path, (CharSequence)volumePath, "create table allowed volume [" + String.valueOf(alias) + "]", true, false));
            }
            if (JitUtil.isJitSupported()) {
                int jitMode = cairoConfig.getSqlJitMode();
                switch (jitMode) {
                    case 0: {
                        this.log.advisoryW().$(" - SQL JIT compiler mode: on").$();
                        break;
                    }
                    case 1: {
                        this.log.advisoryW().$(" - SQL JIT compiler mode: scalar").$();
                        break;
                    }
                    case 2: {
                        this.log.advisoryW().$(" - SQL JIT compiler mode: off").$();
                        break;
                    }
                    default: {
                        this.log.errorW().$(" - Unknown SQL JIT compiler mode: ").$(jitMode).$();
                    }
                }
            }
        }
        MemoryConfiguration ramConfig = this.config.getMemoryConfiguration();
        long ramUsageLimitBytes = ramConfig.getRamUsageLimitBytes();
        long ramUsageLimitPercent = ramConfig.getRamUsageLimitPercent();
        long effectiveRamUsageLimit = ramConfig.getResolvedRamUsageLimitBytes();
        this.log.advisoryW().$(" - configured ram.usage.limit.bytes: ").$(ramUsageLimitBytes != 0L ? SizePrettyFunctionFactory.toSizePretty(ramUsageLimitBytes) : "0 (no limit)").$();
        this.log.advisoryW().$(" - configured ram.usage.limit.percent: ").$(ramUsageLimitPercent != 0L ? Long.valueOf(ramUsageLimitPercent) : "0 (no limit)").$();
        this.log.advisoryW().$(" - system RAM: ").$(SizePrettyFunctionFactory.toSizePretty(ramConfig.getTotalSystemMemory())).$();
        this.log.advisoryW().$(" - resolved RAM usage limit: ").$(effectiveRamUsageLimit != 0L ? SizePrettyFunctionFactory.toSizePretty(effectiveRamUsageLimit) : "0 (no limit)").$();
    }

    private void verifyFileLimits() {
        long mapCountLimit;
        boolean insufficientLimits = false;
        long fileLimit = Files.getFileLimit();
        if (fileLimit < 0L) {
            this.log.error().$("could not read fs.file-max [errno=").$(Os.errno()).I$();
        }
        if (fileLimit > 0L) {
            if (fileLimit <= 65536L) {
                insufficientLimits = true;
                this.log.advisoryW().$("fs.file-max limit is too low [limit=").$(fileLimit).$("] (SYSTEM COULD BE UNSTABLE)").$();
            } else {
                this.log.advisoryW().$("fs.file-max checked [limit=").$(fileLimit).I$();
            }
        }
        if ((mapCountLimit = Files.getMapCountLimit()) < 0L) {
            this.log.error().$("could not read vm.max_map_count [errno=").$(Os.errno()).I$();
        }
        if (mapCountLimit > 0L) {
            if (mapCountLimit <= 65536L) {
                insufficientLimits = true;
                this.log.advisoryW().$("vm.max_map_count limit is too low [limit=").$(mapCountLimit).$("] (SYSTEM COULD BE UNSTABLE)").$();
            } else {
                this.log.advisoryW().$("vm.max_map_count checked [limit=").$(mapCountLimit).I$();
            }
        }
        if (insufficientLimits) {
            this.log.advisoryW().$("make sure to increase fs.file-max and vm.max_map_count limits:\nhttps://questdb.io/docs/deployment/capacity-planning/#os-configuration").$();
        }
    }

    private void verifyFileSystem(Path path, CharSequence rootDir, String kind, boolean failOnNfs, boolean logUnstable) {
        if (rootDir == null) {
            this.log.advisoryW().$(" - ").$(kind).$(" root: NOT SET").$();
            return;
        }
        path.of(rootDir);
        if (Files.exists(path.$())) {
            long fsStatus = Files.getFileSystemStatus(path.$());
            path.seekZ();
            LogRecord rec = this.log.advisoryW().$(" - ").$(kind).$(" root: [path=").$(rootDir).$(", magic=0x");
            if (fsStatus < 0L || fsStatus == 0L && Os.type == 1 && Os.arch == 1) {
                rec.$hex(-fsStatus).$(", fs=").$(path).$("] -> SUPPORTED").$();
            } else {
                rec.$hex(fsStatus).$(", fs=").$(path);
                if (logUnstable) {
                    rec.$("] -> UNSUPPORTED (SYSTEM COULD BE UNSTABLE)").$();
                } else {
                    rec.$("] -> UNSUPPORTED").$();
                }
            }
            if (failOnNfs && fsStatus == 26985L) {
                throw new BootstrapException("Error: Unsupported Filesystem Detected. \r\nQuestDB cannot start because the '" + this.rootDirectory + "' is located on an NFS filesystem, which is not supported. Please relocate your '" + kind + " root' to a supported filesystem to continue. \r\nFor a list of supported filesystems and further guidance, please visit: https://questdb.io/docs/deployment/capacity-planning/#supported-filesystems [path=" + String.valueOf(rootDir) + ", kind=" + kind + ", fs=NFS]", true);
            }
        } else {
            this.log.info().$(" - ").$(kind).$(" root: [path=").$(rootDir).$("] -> NOT FOUND").$();
        }
    }

    void logBannerAndEndpoints(String schema) {
        boolean ilpEnabled = this.config.getHttpServerConfiguration().getLineHttpProcessorConfiguration().isEnabled();
        String indent = "    ";
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(this.banner);
        if (this.config.getHttpServerConfiguration().isEnabled()) {
            sb.append("    ");
            String col1Header = "Web Console URL";
            sb.append(col1Header);
            if (ilpEnabled) {
                Bootstrap.padToNextCol(sb, col1Header.length());
                sb.append("ILP Client Connection String");
            }
            sb.append("\n\n");
            HttpFullFatServerConfiguration httpConf = this.config.getHttpServerConfiguration();
            int bindIP = httpConf.getBindIPv4Address();
            int bindPort = httpConf.getBindPort();
            String contextPathWebConsole = httpConf.getContextPathWebConsole();
            if (bindIP == 0) {
                try {
                    Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
                    while (ni.hasMoreElements()) {
                        Enumeration<InetAddress> addr = ni.nextElement().getInetAddresses();
                        while (addr.hasMoreElements()) {
                            InetAddress inetAddress = addr.nextElement();
                            if (!(inetAddress instanceof Inet4Address)) continue;
                            String leftCol = schema + "://" + inetAddress.getHostAddress() + ":" + bindPort + contextPathWebConsole;
                            sb.append("    ").append(leftCol);
                            if (ilpEnabled) {
                                Bootstrap.padToNextCol(sb, leftCol.length());
                                sb.append(schema).append("::addr=").append(inetAddress.getHostAddress()).append(':').append(bindPort).append(';');
                            }
                            sb.append('\n');
                        }
                    }
                }
                catch (SocketException se) {
                    throw new BootstrapException("Cannot access network interfaces");
                }
                sb.append('\n');
            } else {
                sb.append('\t').append(schema);
                Utf8StringSink sink = new Utf8StringSink();
                Net.appendIP4(sink, bindIP);
                sb.append(sink).append(':').append(bindPort).append('\n');
            }
            if (!ilpEnabled) {
                sb.append("InfluxDB Line Protocol is disabled for HTTP. Enable in server.conf: line.http.enabled=true\n");
            }
        } else {
            sb.append("HTTP server is disabled. Enable in server.conf: http.enabled=true\n");
        }
        sb.append("QuestDB configuration files are in ");
        try {
            sb.append(new File(this.rootDirectory, "conf").getCanonicalPath());
        }
        catch (IOException e) {
            sb.append(new File(this.rootDirectory, "conf").getAbsolutePath());
        }
        sb.append("\n\n");
        String helloMsg = sb.toString();
        this.log.infoW().$(helloMsg).$();
        this.createHelloFile(helloMsg);
    }

    static {
        if (Os.type == -2) {
            throw new Error("QuestDB requires 64-bit JVM");
        }
    }

    public static class BootstrapException
    extends RuntimeException {
        private boolean silentStacktrace = false;

        public BootstrapException(String message) {
            this(message, false);
        }

        public BootstrapException(String message, boolean silentStacktrace) {
            super(message);
            this.silentStacktrace = silentStacktrace;
        }

        public BootstrapException(Throwable thr) {
            super(thr);
        }

        public boolean isSilentStacktrace() {
            return this.silentStacktrace;
        }
    }
}

