/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanFlags;
import io.opentelemetry.exporter.internal.otlp.traces.SpanLinkMarshaler;
import io.opentelemetry.proto.trace.v1.internal.Span;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.io.IOException;

final class SpanLinkStatelessMarshaler
implements StatelessMarshaler<LinkData> {
    static final SpanLinkStatelessMarshaler INSTANCE = new SpanLinkStatelessMarshaler();

    private SpanLinkStatelessMarshaler() {
    }

    public void writeTo(Serializer output, LinkData link, MarshalerContext context) throws IOException {
        output.serializeTraceId(Span.Link.TRACE_ID, link.getSpanContext().getTraceId(), context);
        output.serializeSpanId(Span.Link.SPAN_ID, link.getSpanContext().getSpanId(), context);
        output.serializeString(Span.Link.TRACE_STATE, (byte[])context.getData(byte[].class));
        output.serializeRepeatedMessageWithContext(Span.Link.ATTRIBUTES, link.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = link.getTotalAttributeCount() - link.getAttributes().size();
        output.serializeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        output.serializeFixed32(Span.Link.FLAGS, SpanFlags.withParentIsRemoteFlags(link.getSpanContext().getTraceFlags(), link.getSpanContext().isRemote()));
    }

    public int getBinarySerializedSize(LinkData link, MarshalerContext context) {
        byte[] traceStateUtf8 = SpanLinkMarshaler.encodeSpanLinkTraceState(link);
        context.addData((Object)traceStateUtf8);
        int size = 0;
        size += MarshalerUtil.sizeTraceId((ProtoFieldInfo)Span.Link.TRACE_ID, (String)link.getSpanContext().getTraceId());
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)Span.Link.SPAN_ID, (String)link.getSpanContext().getSpanId());
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)Span.Link.TRACE_STATE, (byte[])traceStateUtf8);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Span.Link.ATTRIBUTES, (Attributes)link.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedAttributesCount = link.getTotalAttributeCount() - link.getAttributes().size();
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.Link.DROPPED_ATTRIBUTES_COUNT, (int)droppedAttributesCount);
        return size += MarshalerUtil.sizeFixed32((ProtoFieldInfo)Span.Link.FLAGS, (int)SpanFlags.withParentIsRemoteFlags(link.getSpanContext().getTraceFlags(), link.getSpanContext().isRemote()));
    }
}

