/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.mqtt;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.mqtt.MqttSslFactory;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.MqttProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class MqttCollectImpl
extends AbstractCollect {
    private static final Logger logger = LoggerFactory.getLogger(MqttCollectImpl.class);

    public String supportProtocol() {
        return "mqtt";
    }

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        MqttProtocol mqttProtocol = metrics.getMqtt();
        Assert.hasText((String)mqttProtocol.getHost(), (String)"MQTT protocol host is required");
        Assert.hasText((String)mqttProtocol.getPort(), (String)"MQTT protocol port is required");
        if ("mqtts".equalsIgnoreCase(mqttProtocol.getProtocol()) && Boolean.parseBoolean(mqttProtocol.getEnableMutualAuth())) {
            Assert.hasText((String)mqttProtocol.getCaCert(), (String)"CA certificate is required for mutual auth");
            Assert.hasText((String)mqttProtocol.getClientCert(), (String)"Client certificate is required for mutual auth");
            Assert.hasText((String)mqttProtocol.getClientKey(), (String)"Client private key is required for mutual auth");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        MqttProtocol mqttProtocol = metrics.getMqtt();
        HashMap<Object, String> data = new HashMap<Object, String>();
        try {
            MqttAsyncClient client = this.buildMqttClient(mqttProtocol);
            long responseTime = this.connectClient(client, mqttProtocol);
            this.testSubscribeAndPublish(client, mqttProtocol, data);
            this.convertToMetricsData(builder, metrics, responseTime, data);
            client.disconnect();
        }
        catch (Exception e) {
            logger.error("MQTT collection error: {}", (Object)e.getMessage(), (Object)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg("Collection failed: " + e.getMessage());
        }
    }

    private MqttAsyncClient buildMqttClient(MqttProtocol protocol) throws Exception {
        String clientId = protocol.getClientId();
        String serverUri = String.format("%s://%s:%s", StringUtils.equals((CharSequence)protocol.getProtocol(), (CharSequence)"MQTT") ? "tcp" : "ssl", protocol.getHost(), protocol.getPort());
        MemoryPersistence persistence = new MemoryPersistence();
        return new MqttAsyncClient(serverUri, clientId, (MqttClientPersistence)persistence);
    }

    private long connectClient(MqttAsyncClient client, MqttProtocol protocol) throws Exception {
        MqttConnectOptions connOpts = new MqttConnectOptions();
        if (protocol.hasAuth()) {
            connOpts.setUserName(protocol.getUsername());
            connOpts.setPassword(protocol.getPassword().toCharArray());
        }
        connOpts.setKeepAliveInterval(Integer.parseInt(protocol.getKeepalive()));
        connOpts.setConnectionTimeout(Integer.parseInt(protocol.getTimeout()) / 1000);
        connOpts.setCleanSession(true);
        connOpts.setAutomaticReconnect(false);
        if ("mqtts".equalsIgnoreCase(protocol.getProtocol())) {
            boolean insecureSkipVerify = Boolean.parseBoolean(protocol.getInsecureSkipVerify());
            if (insecureSkipVerify) {
                connOpts.setHttpsHostnameVerificationEnabled(false);
            }
            if (Boolean.parseBoolean(protocol.getEnableMutualAuth())) {
                connOpts.setSocketFactory((SocketFactory)MqttSslFactory.getMslSocketFactory(protocol, insecureSkipVerify));
            } else {
                connOpts.setSocketFactory((SocketFactory)MqttSslFactory.getSslSocketFactory(protocol, insecureSkipVerify));
            }
        }
        StopWatch connectWatch = new StopWatch();
        connectWatch.start();
        client.connect(connOpts).waitForCompletion(Long.parseLong(protocol.getTimeout()));
        connectWatch.stop();
        return connectWatch.getTotalTimeMillis();
    }

    private void testSubscribeAndPublish(MqttAsyncClient client, MqttProtocol protocol, Map<Object, String> data) {
        String subscribe;
        if (StringUtils.isNotBlank((CharSequence)protocol.getTopic())) {
            subscribe = this.testSubscribe(client, protocol.getTopic());
            if (StringUtils.isBlank((CharSequence)subscribe)) {
                data.put("canSubscribe", "Subscription successful");
            } else {
                data.put("canSubscribe", String.format("Subscription failed: %s", subscribe));
            }
        } else {
            data.put("canSubscribe", "No topic, subscription test skipped");
        }
        if (StringUtils.isNotBlank((CharSequence)protocol.getTestMessage())) {
            String publish = this.testPublish(client, protocol.getTopic(), protocol.getTestMessage());
            if (StringUtils.isBlank((CharSequence)publish)) {
                data.put("canPublish", "Message published successfully");
                String receivedData = this.getReceivedData(client, protocol.getTopic());
                data.put("canReceive", receivedData);
            } else {
                data.put("canPublish", String.format("Message publishing failed: %s", publish));
                data.put("canReceive", "Message reception skipped due to failed publish");
            }
        } else {
            data.put("canPublish", "No test message, publish test skipped");
            data.put("canReceive", "No test message, receive test skipped");
        }
        if (StringUtils.isNotBlank((CharSequence)protocol.getTopic())) {
            subscribe = this.testUnSubscribe(client, protocol.getTopic());
            if (StringUtils.isBlank((CharSequence)subscribe)) {
                data.put("canUnSubscribe", "Unsubscription successful");
            } else {
                data.put("canUnSubscribe", String.format("Unsubscription failed: %s", subscribe));
            }
        } else {
            data.put("canUnSubscribe", "No topic, unsubscription test skipped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReceivedData(MqttAsyncClient client, final String topic) {
        final CountDownLatch latch = new CountDownLatch(1);
        final StringBuilder messageHolder = new StringBuilder();
        client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                latch.countDown();
            }

            public void messageArrived(String arrivedTopic, MqttMessage message) {
                if (topic.equals(arrivedTopic)) {
                    messageHolder.append(new String(message.getPayload()));
                    latch.countDown();
                }
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        try {
            boolean received = latch.await(5L, TimeUnit.SECONDS);
            if (messageHolder.length() > 0) {
                String string = messageHolder.toString();
                return string;
            }
            if (!received) {
                String string = "Message reception timed out after 5 seconds";
                return string;
            }
            String string = "No valid message received";
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String string = e.getMessage();
            return string;
        }
        finally {
            client.setCallback(null);
        }
    }

    private String testSubscribe(MqttAsyncClient client, String topic) {
        try {
            IMqttToken subToken = client.subscribe(topic, 1);
            subToken.waitForCompletion(5000L);
            return "";
        }
        catch (MqttException e) {
            logger.warn("MQTT subscribe test failed: {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    private String testPublish(MqttAsyncClient client, String topic, String message) {
        try {
            MqttMessage mqttMessage = new MqttMessage(message.getBytes());
            mqttMessage.setQos(1);
            IMqttDeliveryToken pubToken = client.publish(topic, mqttMessage);
            pubToken.waitForCompletion(5000L);
            return "";
        }
        catch (MqttException e) {
            logger.warn("MQTT publish test failed: {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    private String testUnSubscribe(MqttAsyncClient client, String topic) {
        try {
            IMqttToken unsubToken = client.unsubscribe(topic);
            unsubToken.waitForCompletion(5000L);
            return "";
        }
        catch (MqttException e) {
            logger.warn("MQTT unsubscribe test failed: {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    private void convertToMetricsData(CollectRep.MetricsData.Builder builder, Metrics metrics, long responseTime, Map<Object, String> data) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String column : metrics.getAliasFields()) {
            if ("responseTime".equals(column)) {
                valueRowBuilder.addColumn(String.valueOf(responseTime));
                continue;
            }
            String value = data.get(column);
            value = value == null ? "&nbsp;" : value;
            valueRowBuilder.addColumn(value);
        }
        builder.addValueRow(valueRowBuilder.build());
    }
}

