/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaMetricRegistry;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.OpenTelemetrySupplier;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.RegisteredObservable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;

public final class OpenTelemetryMetricsReporter
implements MetricsReporter {
    public static final String CONFIG_KEY_OPENTELEMETRY_SUPPLIER = "opentelemetry.supplier";
    public static final String CONFIG_KEY_OPENTELEMETRY_INSTRUMENTATION_NAME = "opentelemetry.instrumentation_name";
    private static final Logger logger = Logger.getLogger(OpenTelemetryMetricsReporter.class.getName());
    private static volatile Listener listener;
    private volatile Meter meter;
    private final Object lock = new Object();
    private final List<RegisteredObservable> registeredObservables = new ArrayList<RegisteredObservable>();

    void resetForTest() {
        this.closeAllInstruments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RegisteredObservable> getRegisteredObservables() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<RegisteredObservable>(this.registeredObservables);
        }
    }

    public OpenTelemetryMetricsReporter() {
        if (listener != null) {
            listener.metricsReporterCreated(this);
        }
    }

    public void init(List<KafkaMetric> metrics) {
        metrics.forEach(this::metricChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricChange(KafkaMetric metric) {
        Meter currentMeter = this.meter;
        if (currentMeter == null) {
            return;
        }
        RegisteredObservable registeredObservable = KafkaMetricRegistry.getRegisteredObservable(currentMeter, metric);
        if (registeredObservable == null) {
            logger.log(Level.FINEST, "Metric changed but cannot map to instrument: {0}", metric.metricName());
            return;
        }
        Set attributeKeys = registeredObservable.getAttributes().asMap().keySet();
        Object object = this.lock;
        synchronized (object) {
            Iterator<RegisteredObservable> it = this.registeredObservables.iterator();
            while (it.hasNext()) {
                RegisteredObservable curRegisteredObservable = it.next();
                Set curAttributeKeys = curRegisteredObservable.getAttributes().asMap().keySet();
                if (curRegisteredObservable.getKafkaMetricName().equals((Object)metric.metricName())) {
                    logger.log(Level.FINEST, "Replacing instrument: {0}", curRegisteredObservable);
                    OpenTelemetryMetricsReporter.closeInstrument(curRegisteredObservable.getObservable());
                    it.remove();
                    continue;
                }
                if (!curRegisteredObservable.getInstrumentDescriptor().equals(registeredObservable.getInstrumentDescriptor()) || attributeKeys.size() <= curAttributeKeys.size() || !attributeKeys.containsAll(curAttributeKeys)) continue;
                logger.log(Level.FINEST, "Replacing instrument with higher dimension version: {0}", curRegisteredObservable);
                OpenTelemetryMetricsReporter.closeInstrument(curRegisteredObservable.getObservable());
                it.remove();
            }
            this.registeredObservables.add(registeredObservable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricRemoval(KafkaMetric metric) {
        logger.log(Level.FINEST, "Metric removed: {0}", metric.metricName());
        Object object = this.lock;
        synchronized (object) {
            Iterator<RegisteredObservable> it = this.registeredObservables.iterator();
            while (it.hasNext()) {
                RegisteredObservable current = it.next();
                if (!current.getKafkaMetricName().equals((Object)metric.metricName())) continue;
                OpenTelemetryMetricsReporter.closeInstrument(current.getObservable());
                it.remove();
            }
        }
    }

    public void close() {
        this.closeAllInstruments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllInstruments() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<RegisteredObservable> it = this.registeredObservables.iterator();
            while (it.hasNext()) {
                OpenTelemetryMetricsReporter.closeInstrument(it.next().getObservable());
                it.remove();
            }
        }
    }

    private static void closeInstrument(AutoCloseable observable) {
        try {
            observable.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred closing instrument", e);
        }
    }

    public void configure(Map<String, ?> configs) {
        OpenTelemetrySupplier openTelemetrySupplier = OpenTelemetryMetricsReporter.getProperty(configs, CONFIG_KEY_OPENTELEMETRY_SUPPLIER, OpenTelemetrySupplier.class);
        OpenTelemetry openTelemetry = openTelemetrySupplier.get();
        String instrumentationName = OpenTelemetryMetricsReporter.getProperty(configs, CONFIG_KEY_OPENTELEMETRY_INSTRUMENTATION_NAME, String.class);
        String instrumentationVersion = EmbeddedInstrumentationProperties.findVersion((String)instrumentationName);
        MeterBuilder meterBuilder = openTelemetry.meterBuilder(instrumentationName);
        if (instrumentationVersion != null) {
            meterBuilder.setInstrumentationVersion(instrumentationVersion);
        }
        this.meter = meterBuilder.build();
    }

    private static <T> T getProperty(Map<String, ?> configs, String key, Class<T> requiredType) {
        Object value = configs.get(key);
        if (value == null) {
            throw new IllegalStateException("Missing required configuration property: " + key);
        }
        if (!requiredType.isInstance(value)) {
            throw new IllegalStateException("Configuration property " + key + " is not instance of " + requiredType.getSimpleName());
        }
        return (T)value;
    }

    static void setListener(Listener listener) {
        OpenTelemetryMetricsReporter.listener = listener;
    }

    static interface Listener {
        public void metricsReporterCreated(OpenTelemetryMetricsReporter var1);
    }
}

