/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.internal.Util;
import org.eclipse.persistence.exceptions.ValidationException;

public class Opcodes {
    private static final String ASM_OPCCODES_ECLIPSELINK = "org.eclipse.persistence.internal.libraries.asm.Opcodes";
    private static final String ASM_OPCCODES_OW2 = "org.objectweb.asm.Opcodes";
    private static final Map<String, String> ASM_OPCCODES_MAP = new HashMap<String, String>();

    public static int valueInt(String fieldName) {
        return (Integer)Util.getFieldValue(ASM_OPCCODES_MAP, fieldName, Integer.TYPE);
    }

    public static Integer valueInteger(String fieldName) {
        return (Integer)Util.getFieldValue(ASM_OPCCODES_MAP, fieldName, Integer.class);
    }

    public static Class getOpcodesClass() {
        Class<?> clazz;
        String asmService = ASMFactory.getAsmService();
        try {
            String className = ASM_OPCCODES_MAP.get(asmService);
            if (className == null) {
                throw ValidationException.incorrectASMServiceProvided();
            }
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw ValidationException.notAvailableASMService();
        }
        return clazz;
    }

    static {
        ASM_OPCCODES_MAP.put("ow2", ASM_OPCCODES_OW2);
        ASM_OPCCODES_MAP.put("eclipselink", ASM_OPCCODES_ECLIPSELINK);
    }
}

