/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Statement;
import com.xugu.common.ReplaceEnum;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class LobClass {
    boolean isLobEmpty;
    boolean isFree;
    boolean is_path;
    String lobDesciptor;
    long lobLen;
    String charData;
    byte[] binaryData;
    Connection lobConnection;
    Statement lobStm;

    public LobClass() {
        this.is_path = false;
    }

    public LobClass(boolean isPath) {
        this.is_path = isPath;
    }

    public LobClass(String clobData) {
        this.charData = clobData == null ? new String() : clobData;
        this.is_path = false;
    }

    public LobClass(byte[] blobData) {
        this.binaryData = blobData;
        this.is_path = false;
    }

    public LobClass(String lobType, byte[] lobData, Statement lobStm, boolean isPath) {
        String charset = null;
        boolean useLobScript = false;
        if (lobStm != null) {
            this.lobStm = lobStm;
            charset = lobStm.connection.getCharSet();
            useLobScript = lobStm.connection.useLobDescribMode();
        }
        this.setLobData(lobData, lobType, charset, useLobScript);
        this.is_path = isPath;
    }

    boolean islobEmpty() {
        return this.isLobEmpty;
    }

    void setLobEmpty(boolean isEmpty) {
        this.isLobEmpty = isEmpty;
    }

    void setLobData(byte[] lobData, String lobType, String charset, boolean useLobDescrpt) {
        try {
            if (lobData != null) {
                if (useLobDescrpt) {
                    int realLen = lobData.length;
                    if ("clob".equals(lobType)) {
                        this.charData = new String(lobData, 0, realLen, charset);
                    } else if ("blob".equals(lobType)) {
                        byte[] realBlobData = new byte[realLen];
                        System.arraycopy(lobData, 0, realBlobData, 0, realLen);
                        this.binaryData = realBlobData;
                    }
                } else if ("clob".equals(lobType)) {
                    this.charData = new String(lobData, charset);
                } else if ("blob".equals(lobType)) {
                    this.binaryData = lobData;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.setLobEmpty(false);
    }

    void checkIndex(long index) throws SQLException {
        this.checkLobFree();
        if (index < 1L || index > this.length() && !this.islobEmpty()) {
            throw Error.createSQLException("[E50011]lob: The beginning of the parameter is out of the value range", ReplaceEnum.excStr.getReplaceStr() + 50011, 50011);
        }
    }

    void checkGetIndexAndLength(long pos, long length, boolean checkTotal) throws SQLException {
        if (pos < 1L || pos > this.length() + 1L && length != -1L) {
            throw Error.createSQLException("[E50011]lob: The beginning of the parameter is out of the value range", ReplaceEnum.excStr.getReplaceStr() + 50011, 50011);
        }
        if (length < 0L && length != -1L) {
            throw Error.createSQLException("[E50012]lob: The length of the parameter is out of the value range", ReplaceEnum.excStr.getReplaceStr() + 50012, 50012);
        }
        if (checkTotal && length + pos - 1L > this.length()) {
            throw Error.createSQLException("[E50013]lob: The parameters are exceeds the lob's range", ReplaceEnum.excStr.getReplaceStr() + 50013, 50013);
        }
    }

    public long length() throws SQLException {
        this.checkLobFree();
        return this.getLobLen();
    }

    private long getLobLen() throws SQLException {
        if (!this.getIsPath()) {
            if (this.charData != null) {
                if (this.islobEmpty()) {
                    return 0L;
                }
                return this.charData.length();
            }
            if (this.binaryData != null) {
                if (this.islobEmpty()) {
                    return 0L;
                }
                return this.binaryData.length;
            }
            return 0L;
        }
        return this.lobLen;
    }

    private synchronized boolean getLobIsFree() {
        return this.isFree;
    }

    void checkLobFree() throws SQLException {
        if (this.getLobIsFree()) {
            throw Error.createSQLException("[E50005]lob: lob\u4e0d\u53ef\u7528\uff0c", ReplaceEnum.excStr.getReplaceStr() + 50005, 50005);
        }
    }

    int checkObjectParam(Object param) {
        int objType = -1;
        if (param == null) {
            return objType;
        }
        if (param instanceof String) {
            if (!"".equals(((String)param).trim())) {
                objType = 1;
            }
        } else if (param instanceof byte[] && ((byte[])param).length > 0) {
            objType = 1;
        }
        return objType;
    }

    void setIsPath(boolean path) {
        this.is_path = path;
    }

    boolean getIsPath() {
        return this.is_path;
    }

    public boolean isInRow() {
        return !this.getIsPath();
    }
}

