/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesResponse;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountTableRefresherThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MountTableRefresherThread.class);
    private boolean success;
    private String adminAddress;
    private CountDownLatch countDownLatch;
    private MountTableManager manager;

    public MountTableRefresherThread(MountTableManager manager, String adminAddress) {
        this.manager = manager;
        this.adminAddress = adminAddress;
        this.setName("MountTableRefresh_" + adminAddress);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            SecurityUtil.doAsLoginUser(() -> {
                if (UserGroupInformation.isSecurityEnabled()) {
                    UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                }
                RefreshMountTableEntriesResponse refreshMountTableEntries = this.manager.refreshMountTableEntries(RefreshMountTableEntriesRequest.newInstance());
                this.success = refreshMountTableEntries.getResult();
                return true;
            });
        }
        catch (IOException e) {
            LOG.error("Failed to refresh mount table entries cache at router {}", (Object)this.adminAddress, (Object)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    @Override
    public String toString() {
        return "MountTableRefreshThread [success=" + this.success + ", adminAddress=" + this.adminAddress + "]";
    }

    public String getAdminAddress() {
        return this.adminAddress;
    }
}

