/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class RequestTimeoutException
extends DocumentClientException {
    public RequestTimeoutException() {
        this("Request timed out.", (URI)null);
    }

    public RequestTimeoutException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(408, error, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public RequestTimeoutException(String message, URI requestUri) {
        this(message, (Exception)null, (HttpResponseHeaders)null, requestUri);
    }

    public RequestTimeoutException(String message, Exception innerException, URI requestUri, String localIpAddress) {
        this(RequestTimeoutException.message(localIpAddress, message), innerException, (HttpResponseHeaders)null, requestUri);
    }

    public RequestTimeoutException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, (HttpResponseHeaders)null, null);
    }

    public RequestTimeoutException(String message, HttpResponseHeaders headers, URI requestUri) {
        super(message, null, HttpUtils.asMap(headers), 408, requestUri != null ? requestUri.toString() : null);
    }

    public RequestTimeoutException(String message, HttpResponseHeaders headers, String requestUri) {
        super(message, null, HttpUtils.asMap(headers), 408, requestUri);
    }

    public RequestTimeoutException(String message, Exception innerException, HttpResponseHeaders headers, URI requestUri) {
        super(message, innerException, HttpUtils.asMap(headers), 408, requestUri != null ? requestUri.toString() : null);
    }

    private static String message(String localIP, String baseMessage) {
        if (!Strings.isNullOrEmpty(localIP)) {
            return String.format("%s, Local IP: %s", baseMessage, localIP);
        }
        return baseMessage;
    }
}

