/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.HttpFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHttpFileSystem {
    private final Configuration conf = new Configuration(false);

    @Before
    public void setUp() {
        this.conf.set("fs.http.impl", HttpFileSystem.class.getCanonicalName());
    }

    @Test
    public void testHttpFileSystem() throws IOException, URISyntaxException, InterruptedException {
        String data = "foo";
        try (MockWebServer server = new MockWebServer();){
            IntStream.rangeClosed(1, 3).forEach(i -> server.enqueue(new MockResponse().setBody("foo")));
            server.start();
            URI uri = URI.create(String.format("http://%s:%d", server.getHostName(), server.getPort()));
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)this.conf);
            this.assertSameData(fs, new Path(new URL(uri.toURL(), "/foo").toURI()), "foo");
            this.assertSameData(fs, new Path("/foo"), "foo");
            this.assertSameData(fs, new Path("foo"), "foo");
            RecordedRequest req = server.takeRequest();
            Assert.assertEquals((Object)"/foo", (Object)req.getPath());
        }
    }

    @Test
    public void testHttpFileStatus() throws IOException, URISyntaxException, InterruptedException {
        URI uri = new URI("http://www.example.com");
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)this.conf);
        URI expectedUri = uri.resolve("/foo");
        Assert.assertEquals((Object)fs.getFileStatus(new Path(new Path(uri), "/foo")).getPath().toUri(), (Object)expectedUri);
        Assert.assertEquals((Object)fs.getFileStatus(new Path("/foo")).getPath().toUri(), (Object)expectedUri);
        Assert.assertEquals((Object)fs.getFileStatus(new Path("foo")).getPath().toUri(), (Object)expectedUri);
    }

    private void assertSameData(FileSystem fs, Path path, String data) throws IOException {
        try (FSDataInputStream is = fs.open(path, 4096);){
            byte[] buf = new byte[data.length()];
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            Assert.assertEquals((Object)data, (Object)new String(buf, StandardCharsets.UTF_8));
        }
    }
}

