/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverterToString;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class ApplicationRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final ApplicationRowKeyConverter appRowKeyConverter = new ApplicationRowKeyConverter();

    public ApplicationRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public byte[] getRowKey() {
        return this.appRowKeyConverter.encode(this);
    }

    public static ApplicationRowKey parseRowKey(byte[] rowKey) {
        return new ApplicationRowKeyConverter().decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.appRowKeyConverter.encodeAsString(this);
    }

    public static ApplicationRowKey parseRowKeyFromString(String encodedRowKey) {
        return new ApplicationRowKeyConverter().decodeFromString(encodedRowKey);
    }

    private static final class ApplicationRowKeyConverter
    implements KeyConverter<ApplicationRowKey>,
    KeyConverterToString<ApplicationRowKey> {
        private final KeyConverter<String> appIDKeyConverter = new AppIdKeyConverter();
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize()};

        private ApplicationRowKeyConverter() {
        }

        @Override
        public byte[] encode(ApplicationRowKey rowKey) {
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] user = Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] flow = Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] first = Separator.QUALIFIERS.join(cluster, user, flow);
            if (rowKey.getFlowRunId() == null) {
                return Separator.QUALIFIERS.join(first, Separator.EMPTY_BYTES);
            }
            byte[] second = Bytes.toBytes((long)LongConverter.invertLong(rowKey.getFlowRunId()));
            if (rowKey.getAppId() == null || rowKey.getAppId().isEmpty()) {
                return Separator.QUALIFIERS.join(first, second, Separator.EMPTY_BYTES);
            }
            byte[] third = this.appIDKeyConverter.encode(rowKey.getAppId());
            return Separator.QUALIFIERS.join(first, second, third);
        }

        @Override
        public ApplicationRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 5) {
                throw new IllegalArgumentException("the row key is not valid for an application");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long flowRunId = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[3]));
            String appId = this.appIDKeyConverter.decode(rowKeyComponents[4]);
            return new ApplicationRowKey(clusterId, userId, flowName, flowRunId, appId);
        }

        @Override
        public String encodeAsString(ApplicationRowKey key) {
            if (key.clusterId == null || key.userId == null || key.flowName == null || key.flowRunId == null || key.appId == null) {
                throw new IllegalArgumentException();
            }
            return TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{key.clusterId, key.userId, key.flowName, key.flowRunId.toString(), key.appId});
        }

        @Override
        public ApplicationRowKey decodeFromString(String encodedRowKey) {
            List split = TimelineReaderUtils.split((String)encodedRowKey);
            if (split == null || split.size() != 5) {
                throw new IllegalArgumentException("Invalid row key for application table.");
            }
            Long flowRunId = Long.valueOf((String)split.get(3));
            return new ApplicationRowKey((String)split.get(0), (String)split.get(1), (String)split.get(2), flowRunId, (String)split.get(4));
        }
    }
}

