/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueCapacityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueUpdateWarning;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceVector;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;

public class AbsoluteResourceCapacityCalculator
extends AbstractQueueCapacityCalculator {
    @Override
    public void calculateResourcePrerequisites(ResourceCalculationDriver resourceCalculationDriver) {
        AbsoluteResourceCapacityCalculator.setNormalizedResourceRatio(resourceCalculationDriver);
    }

    @Override
    public double calculateMinimumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        String resourceName = context.getResourceName();
        double normalizedRatio = resourceCalculationDriver.getNormalizedResourceRatios().getOrDefault(label, ResourceVector.of(1.0)).getValue(resourceName);
        double remainingResourceRatio = resourceCalculationDriver.getRemainingRatioOfResource(label, resourceName);
        return normalizedRatio * remainingResourceRatio * context.getCurrentMinimumCapacityEntry(label).getResourceValue();
    }

    @Override
    public double calculateMaximumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        return context.getCurrentMaximumCapacityEntry(label).getResourceValue();
    }

    @Override
    public void updateCapacitiesAfterCalculation(ResourceCalculationDriver resourceCalculationDriver, CSQueue queue, String label) {
        CapacitySchedulerQueueCapacityHandler.setQueueCapacities(resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label), queue, label);
    }

    @Override
    public QueueCapacityVector.ResourceUnitCapacityType getCapacityType() {
        return QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE;
    }

    public static void setNormalizedResourceRatio(ResourceCalculationDriver calculationDriver) {
        CSQueue queue = calculationDriver.getQueue();
        for (String label : queue.getConfiguredNodeLabels()) {
            if (queue instanceof ManagedParentQueue) {
                return;
            }
            for (String resourceName : queue.getConfiguredCapacityVector(label).getResourceNames()) {
                String unit;
                long convertedValue;
                long childrenConfiguredResource = 0L;
                long effectiveMinResource = queue.getQueueResourceQuotas().getEffectiveMinResource(label).getResourceValue(resourceName);
                for (CSQueue childQueue : queue.getChildQueues()) {
                    QueueCapacityVector capacityVector;
                    if (!childQueue.getConfiguredNodeLabels().contains(label) || !(capacityVector = childQueue.getConfiguredCapacityVector(label)).isResourceOfType(resourceName, QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE)) continue;
                    childrenConfiguredResource = (long)((double)childrenConfiguredResource + capacityVector.getResource(resourceName).getResourceValue());
                }
                if (childrenConfiguredResource == 0L) continue;
                float numeratorForMinRatio = childrenConfiguredResource;
                if (effectiveMinResource < childrenConfiguredResource) {
                    numeratorForMinRatio = queue.getQueueResourceQuotas().getEffectiveMinResource(label).getResourceValue(resourceName);
                    calculationDriver.getUpdateContext().addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.BRANCH_DOWNSCALED.ofQueue(queue.getQueuePath()));
                }
                if ((convertedValue = UnitsConversionUtil.convert((String)(unit = resourceName.equals("memory-mb") ? "Mi" : ""), (String)calculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceInformation(resourceName).getUnits(), (long)childrenConfiguredResource)) == 0L) continue;
                Map<String, ResourceVector> normalizedResourceRatios = calculationDriver.getNormalizedResourceRatios();
                normalizedResourceRatios.putIfAbsent(label, ResourceVector.newInstance());
                normalizedResourceRatios.get(label).setValue(resourceName, numeratorForMinRatio / (float)convertedValue);
            }
        }
    }
}

