/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;
import rx.exceptions.Exceptions;

public class BarrierRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(BarrierRequestHelper.class);

    public static Single<RxDocumentServiceRequest> createAsync(RxDocumentServiceRequest request, IAuthorizationTokenProvider authorizationTokenProvider, Long targetLsn, Long targetGlobalCommittedLsn) {
        boolean isCollectionHeadRequest = BarrierRequestHelper.isCollectionHeadBarrierRequest(request.getResourceType(), request.getOperationType());
        AuthorizationTokenType originalRequestTokenType = request.authorizationTokenType;
        if (originalRequestTokenType == AuthorizationTokenType.Invalid) {
            String message = "AuthorizationTokenType not set for the read request";
            assert (false) : message;
            logger.error(message);
        }
        String authorizationToken = "";
        RxDocumentServiceRequest barrierLsnRequest = null;
        if (!isCollectionHeadRequest) {
            barrierLsnRequest = RxDocumentServiceRequest.create((OperationType)OperationType.HeadFeed, (String)null, (ResourceType)ResourceType.Database, (Map)null);
        } else if (request.getIsNameBased()) {
            String collectionLink = PathsHelper.getCollectionPath((String)request.getResourceAddress());
            barrierLsnRequest = RxDocumentServiceRequest.createFromName((OperationType)OperationType.Head, (String)collectionLink, (ResourceType)ResourceType.DocumentCollection);
        } else {
            barrierLsnRequest = RxDocumentServiceRequest.create((OperationType)OperationType.Head, (String)ResourceId.parse((String)request.getResourceId()).getDocumentCollectionId().toString(), (ResourceType)ResourceType.DocumentCollection, null);
        }
        barrierLsnRequest.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (targetLsn != null && targetLsn > 0L) {
            barrierLsnRequest.getHeaders().put("x-ms-target-lsn", targetLsn.toString());
        }
        if (targetGlobalCommittedLsn != null && targetGlobalCommittedLsn > 0L) {
            barrierLsnRequest.getHeaders().put("x-ms-target-global-committed-lsn", targetGlobalCommittedLsn.toString());
        }
        switch (originalRequestTokenType) {
            case PrimaryMasterKey: 
            case PrimaryReadonlyMasterKey: 
            case SecondaryMasterKey: 
            case SecondaryReadonlyMasterKey: {
                authorizationToken = authorizationTokenProvider.getUserAuthorizationToken(barrierLsnRequest.getResourceAddress(), isCollectionHeadRequest ? ResourceType.DocumentCollection : ResourceType.Database, "HEAD", barrierLsnRequest.getHeaders(), originalRequestTokenType, request.properties);
                break;
            }
            case ResourceToken: {
                authorizationToken = (String)request.getHeaders().get("authorization");
                break;
            }
            default: {
                String unknownAuthToken = "Unknown authorization token kind for read request";
                assert (false) : unknownAuthToken;
                logger.error(unknownAuthToken);
                Exceptions.propagate((Throwable)new InternalServerErrorException("Unknown server error occurred when processing this request."));
            }
        }
        barrierLsnRequest.getHeaders().put("authorization", authorizationToken);
        barrierLsnRequest.requestContext = request.requestContext.clone();
        if (request.getPartitionKeyRangeIdentity() != null) {
            barrierLsnRequest.routeTo(request.getPartitionKeyRangeIdentity());
        }
        if (request.getHeaders().get("x-ms-documentdb-partitionkey") != null) {
            barrierLsnRequest.getHeaders().put("x-ms-documentdb-partitionkey", request.getHeaders().get("x-ms-documentdb-partitionkey"));
        }
        if (request.getHeaders().get("x-ms-documentdb-collection-rid") != null) {
            barrierLsnRequest.getHeaders().put("x-ms-documentdb-collection-rid", request.getHeaders().get("x-ms-documentdb-collection-rid"));
        }
        return Single.just((Object)barrierLsnRequest);
    }

    static boolean isCollectionHeadBarrierRequest(ResourceType resourceType, OperationType operationType) {
        switch (resourceType) {
            case Attachment: 
            case Document: 
            case Conflict: 
            case StoredProcedure: 
            case UserDefinedFunction: 
            case Trigger: {
                return true;
            }
            case DocumentCollection: {
                return operationType != OperationType.ReadFeed && operationType != OperationType.Query && operationType != OperationType.SqlQuery;
            }
            case PartitionKeyRange: {
                return false;
            }
        }
        return false;
    }
}

