/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;

public class JSONTelemetryFormat
implements TelemetryFormat {
    public static final String TELEMETRY_CONFIG_ID = "json";

    @Override
    public String renderDatapointMeasurement(TelemetryDatapointMeasurement datapointMeasurement, EpochFormatter epochFormatter) {
        return datapointMeasurement.toString(this, epochFormatter);
    }

    @Override
    public String renderMetricMeasurement(MetricMeasurement metricMeasurement, EpochFormatter epochFormatter) {
        StringBuilder sb = new StringBuilder("{");
        sb.append(String.format("\"timestamp\":%s,", metricMeasurement.getEpochTimestampNanos()));
        sb.append(String.format("\"metricName\":%s,", metricMeasurement.getMetric().getName()));
        sb.append(String.format("\"value\":%s", metricMeasurement.getValue()));
        if (!metricMeasurement.getMetric().getAttributes().isEmpty()) {
            sb.append(",");
            sb.append(this.renderTelemetryAttributes(metricMeasurement.getMetric().getAttributes()));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String renderOperationStart(Operation operation, long epochTimestampNanos, EpochFormatter epochFormatter) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"eventType\":\"start\",");
        sb.append(String.format("\"timestamp\":%s,", epochTimestampNanos));
        sb.append(String.format("\"id\":\"%s\",", operation.getId()));
        sb.append(this.renderOperation(operation));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String renderOperationEnd(OperationMeasurement operationMeasurement, EpochFormatter epochFormatter) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"eventType\":\"end\",");
        sb.append(String.format("\"timestamp\":%s,", operationMeasurement.getEpochTimestampNanos()));
        sb.append(this.renderOperation(operationMeasurement.getOperation()));
        sb.append(",");
        sb.append("\"elapsed\":").append(operationMeasurement.getElapsedTimeNanos());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String renderOperation(Operation operation) {
        StringBuilder sb = new StringBuilder(String.format("\"id\":\"%s\",\"name\":\"%s\"", operation.getId(), operation.getName()));
        if (!operation.getAttributes().isEmpty()) {
            sb.append(",");
            sb.append(this.renderTelemetryAttributes(operation.getAttributes()));
        }
        return sb.toString();
    }

    @Override
    public String renderTelemetryAttributes(Map<String, Attribute> attributes) {
        return attributes.entrySet().stream().map(mapEntry -> String.format("\"%s\":\"%s\"", mapEntry.getKey(), ((Attribute)mapEntry.getValue()).getValue())).collect(Collectors.joining(","));
    }
}

