/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplication<T extends SchedulerApplicationAttempt> {
    private Queue queue;
    private final String user;
    private volatile T currentAttempt;
    private volatile Priority priority;
    private boolean unmanagedAM;

    public SchedulerApplication(Queue queue, String user, boolean unmanagedAM) {
        this.queue = queue;
        this.user = user;
        this.unmanagedAM = unmanagedAM;
        this.priority = null;
    }

    public SchedulerApplication(Queue queue, String user, Priority priority, boolean unmanagedAM) {
        this.queue = queue;
        this.user = user;
        this.unmanagedAM = unmanagedAM;
        this.priority = priority;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getUser() {
        return this.user;
    }

    public T getCurrentAppAttempt() {
        return this.currentAttempt;
    }

    public void setCurrentAppAttempt(T currentAttempt) {
        this.currentAttempt = currentAttempt;
    }

    public void stop(RMAppState rmAppFinalState) {
        this.queue.getMetrics().finishApp(this.user, rmAppFinalState, this.isUnmanagedAM());
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
        if (null != this.currentAttempt) {
            ((SchedulerApplicationAttempt)this.currentAttempt).setPriority(priority);
        }
    }

    public boolean isUnmanagedAM() {
        return this.unmanagedAM;
    }
}

