/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.URLDispatcher;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.DataNodeUGIProvider;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.hadoop.shaded.io.netty.channel.ChannelFactory;
import org.apache.hadoop.shaded.io.netty.channel.ChannelFuture;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandler;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInitializer;
import org.apache.hadoop.shaded.io.netty.channel.ChannelOption;
import org.apache.hadoop.shaded.io.netty.channel.ChannelPipeline;
import org.apache.hadoop.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.shaded.io.netty.channel.WriteBufferWaterMark;
import org.apache.hadoop.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.hadoop.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.hadoop.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.hadoop.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeHttpServer
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(DatanodeHttpServer.class);
    private static final int HTTP_SELECTOR_THREADS = 1;
    private static final int HTTP_ACCEPTOR_THREADS = 1;
    private static final int HTTP_MAX_THREADS = 4;
    private final HttpServer2 infoServer;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerSocketChannel externalHttpChannel;
    private final ServerBootstrap httpServer;
    private final SSLFactory sslFactory;
    private final ServerBootstrap httpsServer;
    private final Configuration conf;
    private final Configuration confForCreate;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;

    public DatanodeHttpServer(final Configuration conf, DataNode datanode, final ServerSocketChannel externalHttpChannel) throws IOException {
        this.conf = conf;
        Configuration confForInfoServer = new Configuration(conf);
        confForInfoServer.setInt("hadoop.http.max.threads", 4);
        confForInfoServer.setInt("hadoop.http.selector.count", 1);
        confForInfoServer.setInt("hadoop.http.acceptor.count", 1);
        int proxyPort = confForInfoServer.getInt("dfs.datanode.http.internal-proxy.port", 0);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("datanode").setConf(confForInfoServer).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).hostName(DatanodeHttpServer.getHostnameForSpnegoPrincipal(confForInfoServer)).addEndpoint(URI.create("http://localhost:" + proxyPort)).setFindPort(true);
        boolean xFrameEnabled = conf.getBoolean("dfs.xframe.enabled", true);
        String xFrameOptionValue = conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
        builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
        this.infoServer = builder.build();
        this.infoServer.setAttribute("hadoop.conf", (Object)conf);
        this.infoServer.setAttribute("datanode", (Object)datanode);
        this.infoServer.setAttribute("current.conf", (Object)conf);
        this.infoServer.addServlet(null, "/blockScannerReport", BlockScanner.Servlet.class);
        DataNodeUGIProvider.init(conf);
        this.infoServer.start();
        final InetSocketAddress jettyAddr = this.infoServer.getConnectorAddress(0);
        this.confForCreate = new Configuration(conf);
        this.confForCreate.set("fs.permissions.umask-mode", "000");
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.externalHttpChannel = externalHttpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        final ChannelHandler[] handlers = this.getFilterHandlers(conf);
        if (policy.isHttpEnabled()) {
            this.httpServer = new ServerBootstrap().group(this.bossGroup, this.workerGroup).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new HttpRequestDecoder(), new HttpResponseEncoder());
                    if (handlers != null) {
                        for (ChannelHandler c : handlers) {
                            p.addLast(c);
                        }
                    }
                    p.addLast(new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate, false));
                }
            });
            this.httpServer.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(conf.getInt("dfs.webhdfs.netty.low.watermark", 32768), conf.getInt("dfs.webhdfs.netty.high.watermark", 65535)));
            if (externalHttpChannel == null) {
                this.httpServer.channel(NioServerSocketChannel.class);
            } else {
                this.httpServer.channelFactory(new ChannelFactory<NioServerSocketChannel>(){

                    @Override
                    public NioServerSocketChannel newChannel() {
                        return new NioServerSocketChannel(externalHttpChannel){

                            @Override
                            protected void doBind(SocketAddress localAddress) throws Exception {
                            }
                        };
                    }
                });
            }
        } else {
            this.httpServer = null;
        }
        if (policy.isHttpsEnabled()) {
            this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.httpsServer = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new SslHandler(DatanodeHttpServer.this.sslFactory.createSSLEngine()), new HttpRequestDecoder(), new HttpResponseEncoder());
                    if (handlers != null) {
                        for (ChannelHandler c : handlers) {
                            p.addLast(c);
                        }
                    }
                    p.addLast(new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate, true));
                }
            });
        } else {
            this.httpsServer = null;
            this.sslFactory = null;
        }
    }

    private static String getHostnameForSpnegoPrincipal(Configuration conf) {
        String addr = conf.getTrimmed("dfs.datanode.http.address", null);
        if (addr == null) {
            addr = conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:9865");
        }
        InetSocketAddress inetSocker = NetUtils.createSocketAddr((String)addr);
        return inetSocker.getHostString();
    }

    private ChannelHandler[] getFilterHandlers(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        Class[] classes = configuration.getClasses("dfs.datanode.httpserver.filter.handlers", new Class[0]);
        if (classes == null) {
            classes = configuration.getClasses("org.apache.hadoop.hdfs.server.datanode.web.RestCsrfPreventionFilterHandler", new Class[0]);
        }
        if (classes == null) {
            return null;
        }
        ChannelHandler[] handlers = new ChannelHandler[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            LOG.debug("Loading filter handler {}", (Object)classes[i].getName());
            try {
                Method initializeState = classes[i].getDeclaredMethod("initializeState", Configuration.class);
                Constructor constructor = classes[i].getDeclaredConstructor(initializeState.getReturnType());
                handlers[i] = (ChannelHandler)constructor.newInstance(initializeState.invoke(null, configuration));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Failed to initialize handler {}", (Object)classes[i].toString());
                throw new RuntimeException(e);
            }
        }
        return handlers;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    public void start() throws IOException {
        if (this.httpServer != null) {
            InetSocketAddress infoAddr = DataNode.getInfoAddr(this.conf);
            this.httpAddress = this.getChannelLocalAddress(this.httpServer, infoAddr);
            LOG.info("Listening HTTP traffic on " + this.httpAddress);
        }
        if (this.httpsServer != null) {
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)this.conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:9865"));
            this.httpsAddress = this.getChannelLocalAddress(this.httpsServer, secInfoSocAddr);
            LOG.info("Listening HTTPS traffic on " + this.httpsAddress);
        }
    }

    private InetSocketAddress getChannelLocalAddress(ServerBootstrap server, InetSocketAddress address) throws IOException {
        ChannelFuture f = server.bind(address);
        try {
            f.syncUninterruptibly();
        }
        catch (Throwable e) {
            if (e instanceof BindException) {
                throw NetUtils.wrapException(null, (int)0, (String)address.getHostName(), (int)address.getPort(), (IOException)((SocketException)e));
            }
            throw e;
        }
        return (InetSocketAddress)f.channel().localAddress();
    }

    @Override
    public void close() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        if (this.externalHttpChannel != null) {
            this.externalHttpChannel.close();
        }
        try {
            this.infoServer.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static final class MapBasedFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final Map<String, String> parameters;

        public MapBasedFilterConfig(String filterName, Map<String, String> parameters) {
            this.filterName = filterName;
            this.parameters = parameters;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getInitParameter(String name) {
            return this.parameters.get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            throw this.notImplemented();
        }

        public ServletContext getServletContext() {
            throw this.notImplemented();
        }

        private UnsupportedOperationException notImplemented() {
            return new UnsupportedOperationException(this.getClass().getSimpleName() + " does not implement this method.");
        }
    }
}

