/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.NNBench;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNBenchWithoutMR {
    private static final Logger LOG = LoggerFactory.getLogger(NNBenchWithoutMR.class);
    private static long startTime = 0L;
    private static int numFiles = 0;
    private static long bytesPerBlock = 1L;
    private static long blocksPerFile = 0L;
    private static long bytesPerFile = 1L;
    private static short replicationFactorPerFile = 1;
    private static Path baseDir = null;
    private static FileSystem fileSys = null;
    private static Path taskDir = null;
    private static byte[] buffer;
    private static long maxExceptionsPerFile;

    static void barrier() {
        long sleepTime;
        while ((sleepTime = startTime - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void handleException(String operation, Throwable e, int singleFileExceptions) {
        LOG.warn("Exception while " + operation + ": " + StringUtils.stringifyException((Throwable)e));
        if ((long)singleFileExceptions >= maxExceptionsPerFile) {
            throw new RuntimeException(singleFileExceptions + " exceptions for a single file exceeds threshold. Aborting");
        }
    }

    static int createWrite() {
        int totalExceptions = 0;
        FSDataOutputStream out = null;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    out = fileSys.create(new Path(taskDir, "" + index), false, 512, replicationFactorPerFile, bytesPerBlock);
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
            long toBeWritten = bytesPerFile;
            while (toBeWritten > 0L) {
                int nbytes = (int)Math.min((long)buffer.length, toBeWritten);
                toBeWritten -= (long)nbytes;
                try {
                    out.write(buffer, 0, nbytes);
                }
                catch (IOException ioe) {
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("writing to file #" + index, ioe, ++singleFileExceptions);
                }
            }
            do {
                try {
                    out.close();
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("closing file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int openRead() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            int singleFileExceptions = 0;
            try {
                FSDataInputStream in = fileSys.open(new Path(taskDir, "" + index), 512);
                long toBeRead = bytesPerFile;
                while (toBeRead > 0L) {
                    int nbytes = (int)Math.min((long)buffer.length, toBeRead);
                    toBeRead -= (long)nbytes;
                    try {
                        in.read(buffer, 0, nbytes);
                    }
                    catch (IOException ioe) {
                        ++totalExceptions;
                        NNBenchWithoutMR.handleException("reading from file #" + index, ioe, ++singleFileExceptions);
                    }
                }
                in.close();
                continue;
            }
            catch (IOException ioe) {
                ++totalExceptions;
                NNBenchWithoutMR.handleException("opening file #" + index, ioe, ++singleFileExceptions);
            }
        }
        return totalExceptions;
    }

    static int rename() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    fileSys.rename(new Path(taskDir, "" + index), new Path(taskDir, "A" + index));
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int delete() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    fileSys.delete(new Path(taskDir, "A" + index), true);
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    public static void main(String[] args) throws IOException {
        String version = "NameNodeBenchmark.0.3";
        System.out.println(version);
        int bytesPerChecksum = -1;
        String usage = "Usage: nnbench   -operation <one of createWrite, openRead, rename, or delete>\n   -baseDir <base output/input DFS path>\n   -startTime <time to start, given in seconds from the epoch>\n  -numFiles <number of files to create>\n   -replicationFactorPerFile <Replication factor for the files, default is 1>\n  -blocksPerFile <number of blocks to create per file>\n  [-bytesPerBlock <number of bytes to write to each block, default is 1>]\n  [-bytesPerChecksum <value for io.bytes.per.checksum>]\nNote: bytesPerBlock MUST be a multiple of bytesPerChecksum\n";
        String operation = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-baseDir")) {
                baseDir = new Path(args[++i]);
                continue;
            }
            if (args[i].equals("-numFiles")) {
                numFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-blocksPerFile")) {
                blocksPerFile = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesPerBlock")) {
                bytesPerBlock = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesPerChecksum")) {
                bytesPerChecksum = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-replicationFactorPerFile")) {
                replicationFactorPerFile = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-startTime")) {
                startTime = Long.parseLong(args[++i]) * 1000L;
                continue;
            }
            if (args[i].equals("-operation")) {
                operation = args[++i];
                continue;
            }
            System.out.println(usage);
            System.exit(-1);
        }
        bytesPerFile = bytesPerBlock * blocksPerFile;
        JobConf jobConf = new JobConf(new Configuration(), NNBench.class);
        if (bytesPerChecksum < 0) {
            bytesPerChecksum = jobConf.getInt("org.apache.hadoop.shaded.io.bytes.per.checksum", 512);
        }
        jobConf.set("org.apache.hadoop.shaded.io.bytes.per.checksum", Integer.toString(bytesPerChecksum));
        System.out.println("Inputs: ");
        System.out.println("   operation: " + operation);
        System.out.println("   baseDir: " + baseDir);
        System.out.println("   startTime: " + startTime);
        System.out.println("   numFiles: " + numFiles);
        System.out.println("   replicationFactorPerFile: " + replicationFactorPerFile);
        System.out.println("   blocksPerFile: " + blocksPerFile);
        System.out.println("   bytesPerBlock: " + bytesPerBlock);
        System.out.println("   bytesPerChecksum: " + bytesPerChecksum);
        if (operation == null || baseDir == null || numFiles < 1 || blocksPerFile < 1L || bytesPerBlock < 0L || bytesPerBlock % (long)bytesPerChecksum != 0L) {
            System.err.println(usage);
            System.exit(-1);
        }
        fileSys = FileSystem.get((Configuration)jobConf);
        String uniqueId = InetAddress.getLocalHost().getHostName();
        taskDir = new Path(baseDir, uniqueId);
        buffer = new byte[(int)Math.min(bytesPerFile, 32768L)];
        int exceptions = 0;
        NNBenchWithoutMR.barrier();
        Date execTime = new Date();
        System.out.println("Job started: " + startTime);
        if (operation.equals("createWrite")) {
            if (!fileSys.mkdirs(taskDir)) {
                throw new IOException("Mkdirs failed to create " + taskDir.toString());
            }
            exceptions = NNBenchWithoutMR.createWrite();
        } else if (operation.equals("openRead")) {
            exceptions = NNBenchWithoutMR.openRead();
        } else if (operation.equals("rename")) {
            exceptions = NNBenchWithoutMR.rename();
        } else if (operation.equals("delete")) {
            exceptions = NNBenchWithoutMR.delete();
        } else {
            System.err.println(usage);
            System.exit(-1);
        }
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        long duration = (endTime.getTime() - execTime.getTime()) / 1000L;
        System.out.println("The " + operation + " job took " + duration + " seconds.");
        System.out.println("The job recorded " + exceptions + " exceptions.");
    }

    static {
        maxExceptionsPerFile = 200L;
    }
}

