/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.apache.ApacheHttpClient;

public final class NetworkBinding {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkBinding.class);
    private static final String BINDING_CLASSNAME = "org.apache.hadoop.fs.s3a.impl.ConfigureShadedAWSSocketFactory";

    private NetworkBinding() {
    }

    public static void bindSSLChannelMode(Configuration conf, ApacheHttpClient.Builder httpClientBuilder) throws IOException {
        String channelModeString = conf.getTrimmed("fs.s3a.ssl.channel.mode", Constants.DEFAULT_SSL_CHANNEL_MODE.name());
        DelegatingSSLSocketFactory.SSLChannelMode channelMode = null;
        for (DelegatingSSLSocketFactory.SSLChannelMode mode : DelegatingSSLSocketFactory.SSLChannelMode.values()) {
            if (!mode.name().equalsIgnoreCase(channelModeString)) continue;
            channelMode = mode;
        }
        if (channelMode == null) {
            throw new IllegalArgumentException(channelModeString + " is not a valid value for " + "fs.s3a.ssl.channel.mode");
        }
        DelegatingSSLSocketFactory.initializeDefaultFactory(channelMode);
        try {
            Class<?> clazz = Class.forName(BINDING_CLASSNAME);
            ((ConfigureAWSSocketFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).configureSocketFactory(httpClientBuilder, channelMode);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("Unable to create class {}, value of {} will be ignored", new Object[]{BINDING_CLASSNAME, "fs.s3a.ssl.channel.mode", e});
        }
    }

    public static boolean isAwsEndpoint(String endpoint) {
        return endpoint.isEmpty() || endpoint.endsWith(".amazonaws.com") || endpoint.endsWith(".amazonaws.com.cn");
    }

    public static String fixBucketRegion(String region) {
        return region == null || region.equals("US") ? "us-east-1" : region;
    }

    public static void logDnsLookup(Configuration conf) {
        String endPoint;
        String hostName = endPoint = conf.getTrimmed("fs.s3a.endpoint", "");
        if (!endPoint.isEmpty() && LOG.isDebugEnabled()) {
            if (endPoint.contains("://")) {
                try {
                    URI uri = new URI(endPoint);
                    hostName = uri.getHost();
                }
                catch (URISyntaxException e) {
                    LOG.debug("Got URISyntaxException, ignoring");
                }
            }
            LOG.debug("Bucket endpoint : {}, Hostname : {}, DNSAddress : {}", new Object[]{endPoint, hostName, NetUtils.normalizeHostName((String)hostName)});
        }
    }

    static interface ConfigureAWSSocketFactory {
        public void configureSocketFactory(ApacheHttpClient.Builder var1, DelegatingSSLSocketFactory.SSLChannelMode var2) throws IOException;
    }
}

