/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.azure.cosmosdb.ConsistencyPolicy;
import com.microsoft.azure.cosmosdb.DatabaseAccountLocation;
import com.microsoft.azure.cosmosdb.ReplicationPolicy;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabaseAccount
extends Resource {
    private ConsistencyPolicy consistencyPolicy;
    private long maxMediaStorageUsageInMB;
    private long mediaStorageUsageInMB;
    private ReplicationPolicy replicationPolicy;
    private ReplicationPolicy systemReplicationPolicy;
    private Map<String, Object> queryEngineConfiguration;

    DatabaseAccount() {
        this.setSelfLink("");
    }

    public DatabaseAccount(String jsonString) {
        super(jsonString);
    }

    public String getDatabasesLink() {
        return super.getString("_dbs");
    }

    void setDatabasesLink(String databasesLink) {
        super.set("_dbs", databasesLink);
    }

    public String getMediaLink() {
        return super.getString("media");
    }

    void setMediaLink(String medialink) {
        super.set("media", medialink);
    }

    public String getAddressesLink() {
        return super.getString("addresses");
    }

    void setAddressesLink(String addresseslink) {
        super.set("addresses", addresseslink);
    }

    public long getMaxMediaStorageUsageInMB() {
        return this.maxMediaStorageUsageInMB;
    }

    void setMaxMediaStorageUsageInMB(long value) {
        this.maxMediaStorageUsageInMB = value;
    }

    public long getMediaStorageUsageInMB() {
        return this.mediaStorageUsageInMB;
    }

    void setMediaStorageUsageInMB(long value) {
        this.mediaStorageUsageInMB = value;
    }

    public ConsistencyPolicy getConsistencyPolicy() {
        if (this.consistencyPolicy == null) {
            this.consistencyPolicy = super.getObject("userConsistencyPolicy", ConsistencyPolicy.class);
            if (this.consistencyPolicy == null) {
                this.consistencyPolicy = new ConsistencyPolicy();
            }
        }
        return this.consistencyPolicy;
    }

    public ReplicationPolicy getReplicationPolicy() {
        if (this.replicationPolicy == null) {
            this.replicationPolicy = super.getObject("userReplicationPolicy", ReplicationPolicy.class);
            if (this.replicationPolicy == null) {
                this.replicationPolicy = new ReplicationPolicy();
            }
        }
        return this.replicationPolicy;
    }

    ReplicationPolicy getSystemReplicationPolicy() {
        if (this.systemReplicationPolicy == null) {
            this.systemReplicationPolicy = super.getObject("systemReplicationPolicy", ReplicationPolicy.class);
            if (this.systemReplicationPolicy == null) {
                this.systemReplicationPolicy = new ReplicationPolicy();
            }
        }
        return this.systemReplicationPolicy;
    }

    Map<String, Object> getQueryEngineConfiuration() {
        String queryEngineConfigurationJsonString;
        if (this.queryEngineConfiguration == null && StringUtils.isNotEmpty((CharSequence)(queryEngineConfigurationJsonString = super.getObject("queryEngineConfiguration", String.class)))) {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            try {
                this.queryEngineConfiguration = (Map)Utils.getSimpleObjectMapper().readValue(queryEngineConfigurationJsonString, (TypeReference)typeRef);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (this.queryEngineConfiguration == null) {
                this.queryEngineConfiguration = new HashMap<String, Object>();
            }
        }
        return this.queryEngineConfiguration;
    }

    public Iterable<DatabaseAccountLocation> getWritableLocations() {
        return super.getCollection("writableLocations", DatabaseAccountLocation.class);
    }

    void setWritableLocations(Iterable<DatabaseAccountLocation> locations) {
        super.set("writableLocations", locations);
    }

    public Iterable<DatabaseAccountLocation> getReadableLocations() {
        return super.getCollection("readableLocations", DatabaseAccountLocation.class);
    }

    void setReadableLocations(Iterable<DatabaseAccountLocation> locations) {
        super.set("readableLocations", locations);
    }

    boolean isEnableMultipleWriteLocations() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)super.getBoolean("enableMultipleWriteLocations"), (Object)false);
    }

    void setEnableMultipleWriteLocations(boolean value) {
        super.set("enableMultipleWriteLocations", value);
    }

    @Override
    void populatePropertyBag() {
        if (this.consistencyPolicy != null) {
            this.consistencyPolicy.populatePropertyBag();
            super.set("userConsistencyPolicy", this.consistencyPolicy);
        }
    }
}

