/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe.internal;

import java.time.Duration;
import software.amazon.s3.shaded.dev.failsafe.RateLimiterConfig;
import software.amazon.s3.shaded.dev.failsafe.internal.RateLimiterStats;
import software.amazon.s3.shaded.dev.failsafe.internal.util.Maths;

class SmoothRateLimiterStats
extends RateLimiterStats {
    final long intervalNanos;
    private long nextFreePermitNanos;

    SmoothRateLimiterStats(RateLimiterConfig<?> config, RateLimiterStats.Stopwatch stopwatch) {
        super(stopwatch);
        this.intervalNanos = config.getMaxRate().toNanos();
    }

    @Override
    public synchronized long acquirePermits(long requestedPermits, Duration maxWaitTime) {
        long newNextFreePermitNanos;
        long currentNanos = this.stopwatch.elapsedNanos();
        long requestedPermitNanos = requestedPermits * this.intervalNanos;
        if (currentNanos >= this.nextFreePermitNanos) {
            long currentIntervalNanos = Maths.roundDown(currentNanos, this.intervalNanos);
            newNextFreePermitNanos = Maths.add(currentIntervalNanos, requestedPermitNanos);
        } else {
            newNextFreePermitNanos = Maths.add(this.nextFreePermitNanos, requestedPermitNanos);
        }
        long waitNanos = Math.max(newNextFreePermitNanos - currentNanos - this.intervalNanos, 0L);
        if (this.exceedsMaxWaitTime(waitNanos, maxWaitTime)) {
            return -1L;
        }
        this.nextFreePermitNanos = newNextFreePermitNanos;
        return waitNanos;
    }

    synchronized long getNextFreePermitNanos() {
        return this.nextFreePermitNanos;
    }

    @Override
    synchronized void reset() {
        this.stopwatch.reset();
        this.nextFreePermitNanos = 0L;
    }
}

