/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MkdirOp
extends Operation {
    private static final Logger LOG = LoggerFactory.getLogger(MkdirOp.class);

    MkdirOp(ConfigExtractor cfg, Random rnd) {
        super(MkdirOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getDirectory() {
        Path dir = this.getFinder().getDirectory();
        return dir;
    }

    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        try {
            Path dir = this.getDirectory();
            boolean mkRes = false;
            long timeTaken = 0L;
            long startTime = Timer.now();
            mkRes = fs.mkdirs(dir);
            timeTaken = Timer.elapsed(startTime);
            if (mkRes) {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
                LOG.info("Made directory " + dir);
            } else {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
                LOG.warn("Could not make " + dir);
            }
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn("Error with mkdir", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn("Error with mkdir", (Throwable)e);
        }
        return out;
    }
}

