/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.TextFileRegionAliasMap;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.GzipCodec;
import org.junit.Assert;
import org.junit.Test;

public class TestTextBlockAliasMap {
    static final String OUTFILE_PATH = "hdfs://dummyServer:0000/";
    static final String OUTFILE_BASENAME = "dummyFile";
    static final Path OUTFILE = new Path("hdfs://dummyServer:0000/", "dummyFiletxt");
    static final String BPID = "BPID-0";

    void check(TextFileRegionAliasMap.TextWriter.Options opts, final Path vp, final Class<? extends CompressionCodec> vc) throws IOException {
        TextFileRegionAliasMap mFmt = new TextFileRegionAliasMap(){

            public TextFileRegionAliasMap.TextWriter createWriter(Path file, CompressionCodec codec, String delim, Configuration conf) throws IOException {
                Assert.assertEquals((Object)vp, (Object)file);
                if (null == vc) {
                    Assert.assertNull((Object)codec);
                } else {
                    Assert.assertEquals((Object)vc, codec.getClass());
                }
                return null;
            }
        };
        mFmt.getWriter((BlockAliasMap.Writer.Options)opts, BPID);
    }

    void check(TextFileRegionAliasMap.TextReader.Options opts, final Path vp, final Class<? extends CompressionCodec> vc) throws IOException {
        TextFileRegionAliasMap aliasMap = new TextFileRegionAliasMap(){

            public TextFileRegionAliasMap.TextReader createReader(Path file, String delim, Configuration cfg, String blockPoolID) throws IOException {
                Assert.assertEquals((Object)vp, (Object)file);
                if (null != vc) {
                    CompressionCodecFactory factory = new CompressionCodecFactory(cfg);
                    CompressionCodec codec = factory.getCodec(file);
                    Assert.assertEquals((Object)vc, codec.getClass());
                }
                return null;
            }
        };
        aliasMap.getReader((BlockAliasMap.Reader.Options)opts, BPID);
    }

    @Test
    public void testWriterOptions() throws Exception {
        TextFileRegionAliasMap.WriterOptions opts = TextFileRegionAliasMap.TextWriter.defaults();
        Assert.assertTrue((boolean)(opts instanceof TextFileRegionAliasMap.WriterOptions));
        TextFileRegionAliasMap.WriterOptions wopts = opts;
        Path def = new Path("file:///tmp/");
        Assert.assertEquals((Object)def, (Object)wopts.getDir());
        Assert.assertNull((Object)wopts.getCodec());
        Path cp = new Path(OUTFILE_PATH, "blocks_BPID-0.csv");
        opts.dirName(new Path(OUTFILE_PATH));
        this.check((TextFileRegionAliasMap.TextWriter.Options)opts, cp, null);
        opts.codec("gzip");
        cp = new Path(OUTFILE_PATH, "blocks_BPID-0.csv.gz");
        this.check((TextFileRegionAliasMap.TextWriter.Options)opts, cp, GzipCodec.class);
    }

    @Test
    public void testReaderOptions() throws Exception {
        TextFileRegionAliasMap.ReaderOptions opts = TextFileRegionAliasMap.TextReader.defaults();
        Assert.assertTrue((boolean)(opts instanceof TextFileRegionAliasMap.ReaderOptions));
        TextFileRegionAliasMap.ReaderOptions ropts = opts;
        Path cp = new Path(OUTFILE_PATH, TextFileRegionAliasMap.fileNameFromBlockPoolID((String)BPID));
        opts.filename(cp);
        this.check((TextFileRegionAliasMap.TextReader.Options)opts, cp, null);
        cp = new Path(OUTFILE_PATH, "blocks_BPID-0.csv.gz");
        opts.filename(cp);
        this.check((TextFileRegionAliasMap.TextReader.Options)opts, cp, GzipCodec.class);
    }

    @Test
    public void testCSVReadWrite() throws Exception {
        Iterator i3;
        final DataOutputBuffer out = new DataOutputBuffer();
        FileRegion r1 = new FileRegion(4344L, OUTFILE, 0L, 1024L);
        FileRegion r2 = new FileRegion(4345L, OUTFILE, 1024L, 1024L);
        FileRegion r3 = new FileRegion(4346L, OUTFILE, 2048L, 512L);
        try (TextFileRegionAliasMap.TextWriter csv = new TextFileRegionAliasMap.TextWriter((Writer)new OutputStreamWriter((OutputStream)out), ",");){
            csv.store(r1);
            csv.store(r2);
            csv.store(r3);
        }
        try (TextFileRegionAliasMap.TextReader csv = new TextFileRegionAliasMap.TextReader(null, null, null, ","){

            public InputStream createStream() {
                DataInputBuffer in = new DataInputBuffer();
                in.reset(out.getData(), 0, out.getLength());
                return in;
            }
        };){
            Iterator i1 = csv.iterator();
            Assert.assertEquals((Object)r1, i1.next());
            Iterator i2 = csv.iterator();
            Assert.assertEquals((Object)r1, i2.next());
            Assert.assertEquals((Object)r2, i2.next());
            Assert.assertEquals((Object)r3, i2.next());
            Assert.assertEquals((Object)r2, i1.next());
            Assert.assertEquals((Object)r3, i1.next());
            Assert.assertFalse((boolean)i1.hasNext());
            Assert.assertFalse((boolean)i2.hasNext());
            i3 = csv.iterator();
        }
        try {
            i3.next();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)"Invalid iterator");
    }

    @Test
    public void testCSVReadWriteTsv() throws Exception {
        Iterator i3;
        final DataOutputBuffer out = new DataOutputBuffer();
        FileRegion r1 = new FileRegion(4344L, OUTFILE, 0L, 1024L);
        FileRegion r2 = new FileRegion(4345L, OUTFILE, 1024L, 1024L);
        FileRegion r3 = new FileRegion(4346L, OUTFILE, 2048L, 512L);
        try (TextFileRegionAliasMap.TextWriter csv = new TextFileRegionAliasMap.TextWriter((Writer)new OutputStreamWriter((OutputStream)out), "\t");){
            csv.store(r1);
            csv.store(r2);
            csv.store(r3);
        }
        try (TextFileRegionAliasMap.TextReader csv = new TextFileRegionAliasMap.TextReader(null, null, null, "\t"){

            public InputStream createStream() {
                DataInputBuffer in = new DataInputBuffer();
                in.reset(out.getData(), 0, out.getLength());
                return in;
            }
        };){
            Iterator i1 = csv.iterator();
            Assert.assertEquals((Object)r1, i1.next());
            Iterator i2 = csv.iterator();
            Assert.assertEquals((Object)r1, i2.next());
            Assert.assertEquals((Object)r2, i2.next());
            Assert.assertEquals((Object)r3, i2.next());
            Assert.assertEquals((Object)r2, i1.next());
            Assert.assertEquals((Object)r3, i1.next());
            Assert.assertFalse((boolean)i1.hasNext());
            Assert.assertFalse((boolean)i2.hasNext());
            i3 = csv.iterator();
        }
        try {
            i3.next();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)"Invalid iterator");
    }
}

