/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerPrepareContext {
    private final Container container;
    private final Map<Path, List<String>> localizedResources;
    private final String user;
    private final List<String> containerLocalDirs;
    private final List<String> commands;

    private ContainerPrepareContext(Builder builder) {
        this.container = builder.container;
        this.localizedResources = builder.localizedResources;
        this.user = builder.user;
        this.containerLocalDirs = builder.containerLocalDirs;
        this.commands = builder.commands;
    }

    public Container getContainer() {
        return this.container;
    }

    public Map<Path, List<String>> getLocalizedResources() {
        if (this.localizedResources != null) {
            return Collections.unmodifiableMap(this.localizedResources);
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public List<String> getContainerLocalDirs() {
        return Collections.unmodifiableList(this.containerLocalDirs);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public static final class Builder {
        private Container container;
        private Map<Path, List<String>> localizedResources;
        private String user;
        private List<String> containerLocalDirs;
        private List<String> commands;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setLocalizedResources(Map<Path, List<String>> localizedResources) {
            this.localizedResources = localizedResources;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setContainerLocalDirs(List<String> containerLocalDirs) {
            this.containerLocalDirs = containerLocalDirs;
            return this;
        }

        public ContainerPrepareContext build() {
            return new ContainerPrepareContext(this);
        }

        public Builder setCommands(List<String> commands) {
            this.commands = commands;
            return this;
        }
    }
}

