/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.crypto.NativeCodeLoader;
import org.apache.commons.crypto.OpenSslInfoNative;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;

public final class Crypto {
    public static final String CONF_PREFIX = "commons.crypto.";
    public static final String LIB_NAME_KEY = "commons.crypto.lib.name";
    public static final String LIB_PATH_KEY = "commons.crypto.lib.path";
    public static final String LIB_TEMPDIR_KEY = "commons.crypto.lib.tempdir";

    public static String getComponentName() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("NAME");
    }

    public static String getComponentVersion() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("VERSION");
    }

    public static Throwable getLoadingError() {
        return NativeCodeLoader.getLoadingError();
    }

    private static void info(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static boolean isNativeCodeLoaded() {
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static void main(String[] args) throws Exception {
        Crypto.info("%s %s", Crypto.getComponentName(), Crypto.getComponentVersion());
        if (Crypto.isNativeCodeLoaded()) {
            Crypto.info("Native code loaded OK: %s", OpenSslInfoNative.NativeVersion());
            Crypto.info("Native name: %s", OpenSslInfoNative.NativeName());
            Crypto.info("Native built: %s", OpenSslInfoNative.NativeTimeStamp());
            Crypto.info("OpenSSL library loaded OK, version: 0x%s", Long.toHexString(OpenSslInfoNative.OpenSSL()));
            Crypto.info("OpenSSL library info: %s", OpenSslInfoNative.OpenSSLVersion(0));
            Properties props = new Properties();
            props.setProperty("commons.crypto.secure.random.classes", CryptoRandomFactory.RandomProvider.OPENSSL.getClassName());
            try (CryptoRandom cryptoRandom = CryptoRandomFactory.getCryptoRandom(props);){
                Crypto.info("Random instance created OK: %s", cryptoRandom);
            }
            props = new Properties();
            props.setProperty("commons.crypto.cipher.classes", CryptoCipherFactory.CipherProvider.OPENSSL.getClassName());
            String transformation = "AES/CTR/NoPadding";
            try (CryptoCipher cryptoCipher = CryptoCipherFactory.getCryptoCipher("AES/CTR/NoPadding", props);){
                Crypto.info("Cipher %s instance created OK: %s", "AES/CTR/NoPadding", cryptoCipher);
            }
            Crypto.info("Additional OpenSSL_version(n) details:", new Object[0]);
            for (int j = 1; j < 6; ++j) {
                Crypto.info("%s: %s", j, OpenSslInfoNative.OpenSSLVersion(j));
            }
        } else {
            Crypto.info("Native load failed: %s", Crypto.getLoadingError());
        }
    }

    private static class ComponentPropertiesHolder {
        static final Properties PROPERTIES = ComponentPropertiesHolder.getComponentProperties();

        private ComponentPropertiesHolder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Properties getComponentProperties() {
            URL url = Crypto.class.getResource("/org/apache/commons/crypto/component.properties");
            Properties versionData = new Properties();
            if (url == null) return versionData;
            try (InputStream inputStream = url.openStream();){
                versionData.load(inputStream);
                Properties properties = versionData;
                return properties;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return versionData;
        }
    }
}

