/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueConfigurationAutoRefreshPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;

public class FSYarnSiteConverter {
    private boolean preemptionEnabled;
    private boolean sizeBasedWeight;

    public void convertSiteProperties(Configuration conf, Configuration yarnSiteConfig, boolean drfUsed, boolean enableAsyncScheduler, boolean userPercentage, FSConfigToCSConfigConverterParams.PreemptionMode preemptionMode) {
        float localityThresholdRack;
        float localityThresholdNode;
        yarnSiteConfig.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        if (conf.getBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", false)) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true);
            int interval = conf.getInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 5);
            yarnSiteConfig.setInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", interval);
        }
        yarnSiteConfig.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        if (conf.getBoolean("yarn.scheduler.fair.preemption", false)) {
            this.preemptionEnabled = true;
            String policies = this.addMonitorPolicy(ProportionalCapacityPreemptionPolicy.class.getCanonicalName(), yarnSiteConfig);
            yarnSiteConfig.set("yarn.resourcemanager.scheduler.monitor.policies", policies);
            int waitTimeBeforeKill = conf.getInt("yarn.scheduler.fair.waitTimeBeforeKill", 15000);
            yarnSiteConfig.setInt("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", waitTimeBeforeKill);
            long waitBeforeNextStarvationCheck = conf.getLong("yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck", 10000L);
            yarnSiteConfig.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", waitBeforeNextStarvationCheck);
        } else if (preemptionMode == FSConfigToCSConfigConverterParams.PreemptionMode.NO_POLICY) {
            yarnSiteConfig.set("yarn.resourcemanager.scheduler.monitor.policies", "");
        }
        if (!userPercentage) {
            String policies = this.addMonitorPolicy(AutoCreatedQueueDeletionPolicy.class.getCanonicalName(), yarnSiteConfig);
            yarnSiteConfig.set("yarn.resourcemanager.scheduler.monitor.policies", policies);
            yarnSiteConfig.setInt("yarn.scheduler.capacity.auto-queue-creation-v2.queue-expiration-time", 10);
        }
        if (conf.getBoolean("yarn.scheduler.fair.assignmultiple", false)) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", true);
        } else {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", false);
        }
        yarnSiteConfig.set("yarn.resourcemanager.scheduler.monitor.policies", this.addMonitorPolicy(QueueConfigurationAutoRefreshPolicy.class.getCanonicalName(), yarnSiteConfig));
        int maxAssign = conf.getInt("yarn.scheduler.fair.max.assign", -1);
        if (maxAssign != -1) {
            yarnSiteConfig.setInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", maxAssign);
        }
        if ((localityThresholdNode = conf.getFloat("yarn.scheduler.fair.locality.threshold.node", -1.0f)) != -1.0f) {
            yarnSiteConfig.setFloat("yarn.scheduler.capacity.node-locality-delay", localityThresholdNode);
        }
        if ((localityThresholdRack = conf.getFloat("yarn.scheduler.fair.locality.threshold.rack", -1.0f)) != -1.0f) {
            yarnSiteConfig.setFloat("yarn.scheduler.capacity.rack-locality-additional-delay", localityThresholdRack);
        }
        if (conf.getBoolean("yarn.scheduler.fair.sizebasedweight", false)) {
            this.sizeBasedWeight = true;
        }
        if (drfUsed) {
            yarnSiteConfig.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getCanonicalName());
        }
        if (enableAsyncScheduler) {
            yarnSiteConfig.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true);
        }
    }

    public boolean isPreemptionEnabled() {
        return this.preemptionEnabled;
    }

    public boolean isSizeBasedWeight() {
        return this.sizeBasedWeight;
    }

    private String addMonitorPolicy(String policyName, Configuration yarnSiteConfig) {
        String policies = yarnSiteConfig.get("yarn.resourcemanager.scheduler.monitor.policies");
        policies = policies == null || policies.isEmpty() ? policyName : policies + "," + policyName;
        return policies;
    }
}

