/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.table;

import com.google.common.base.Preconditions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTable;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTableCatalog;

public class GravitinoSystemTableFactory {
    private final CatalogConnectorManager catalogConnectorManager;
    public static final Map<SchemaTableName, GravitinoSystemTable> SYSTEM_TABLES = new HashMap<SchemaTableName, GravitinoSystemTable>();

    public GravitinoSystemTableFactory(CatalogConnectorManager catalogConnectorManager) {
        this.catalogConnectorManager = catalogConnectorManager;
        this.registerSystemTables();
    }

    private void registerSystemTables() {
        SYSTEM_TABLES.put(GravitinoSystemTableCatalog.TABLE_NAME, new GravitinoSystemTableCatalog(this.catalogConnectorManager));
    }

    public static Page loadPageData(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)SYSTEM_TABLES.containsKey(tableName), (Object)"table does not exist");
        return SYSTEM_TABLES.get(tableName).loadPageData();
    }

    public static ConnectorTableMetadata getTableMetaData(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)SYSTEM_TABLES.containsKey(tableName), (Object)"table does not exist");
        return SYSTEM_TABLES.get(tableName).getTableMetaData();
    }
}

