/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ListTablesIterable
implements Iterable<String> {
    private final LanceNamespace namespace;
    private final ListTablesRequest initialRequest;

    public ListTablesIterable(LanceNamespace namespace, ListTablesRequest initialRequest) {
        this.namespace = namespace;
        this.initialRequest = initialRequest;
    }

    @Override
    public Iterator<String> iterator() {
        return new ListTablesIterator();
    }

    private class ListTablesIterator
    implements Iterator<String> {
        private Iterator<String> currentPageIterator;
        private String nextPageToken;
        private boolean hasMorePages = true;
        private boolean initialized = false;

        private ListTablesIterator() {
        }

        @Override
        public boolean hasNext() {
            this.ensureInitialized();
            if (this.currentPageIterator != null && this.currentPageIterator.hasNext()) {
                return true;
            }
            if (!this.hasMorePages) {
                return false;
            }
            this.loadNextPage();
            return this.currentPageIterator != null && this.currentPageIterator.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more table names available");
            }
            return this.currentPageIterator.next();
        }

        private void ensureInitialized() {
            if (!this.initialized) {
                this.loadNextPage();
                this.initialized = true;
            }
        }

        private void loadNextPage() {
            try {
                ListTablesRequest request = new ListTablesRequest().id(ListTablesIterable.this.initialRequest.getId()).limit(ListTablesIterable.this.initialRequest.getLimit()).pageToken(this.nextPageToken);
                ListTablesResponse response = ListTablesIterable.this.namespace.listTables(request);
                Set tables = response.getTables();
                this.currentPageIterator = tables != null ? tables.iterator() : null;
                this.nextPageToken = response.getPageToken();
                this.hasMorePages = this.nextPageToken != null && !this.nextPageToken.isEmpty();
            }
            catch (Exception e) {
                this.hasMorePages = false;
                this.currentPageIterator = null;
                throw new RuntimeException("Failed to load table names", e);
            }
        }
    }
}

