/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvVarConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(EnvVarConfigProvider.class);
    public static final String ALLOWLIST_PATTERN_CONFIG = "allowlist.pattern";
    public static final String ALLOWLIST_PATTERN_CONFIG_DOC = "A pattern / regular expression that needs to match for environment variables to be used by this config provider.";
    private final Map<String, String> envVarMap;
    private Map<String, String> filteredEnvVarMap;

    public EnvVarConfigProvider() {
        this.envVarMap = this.getEnvVars();
    }

    public EnvVarConfigProvider(Map<String, String> envVarsAsArgument) {
        this.envVarMap = envVarsAsArgument;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Pattern envVarPattern;
        if (configs.containsKey(ALLOWLIST_PATTERN_CONFIG)) {
            envVarPattern = Pattern.compile(String.valueOf(configs.get(ALLOWLIST_PATTERN_CONFIG)));
        } else {
            envVarPattern = Pattern.compile(".*");
            log.info("No pattern for environment variables provided. Using default pattern '(.*)'.");
        }
        this.filteredEnvVarMap = this.envVarMap.entrySet().stream().filter(envVar -> envVarPattern.matcher((CharSequence)envVar.getKey()).matches()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ConfigData get(String path) {
        return this.get(path, null);
    }

    @Override
    public ConfigData get(String path, Set<String> keys) {
        if (path != null && !path.isEmpty()) {
            log.error("Path is not supported for EnvVarConfigProvider, invalid value '{}'", (Object)path);
            throw new ConfigException("Path is not supported for EnvVarConfigProvider, invalid value '" + path + "'");
        }
        if (keys == null) {
            return new ConfigData(this.filteredEnvVarMap);
        }
        HashMap<String, String> filteredData = new HashMap<String, String>(this.filteredEnvVarMap);
        filteredData.keySet().retainAll(keys);
        return new ConfigData(filteredData);
    }

    private Map<String, String> getEnvVars() {
        try {
            return System.getenv();
        }
        catch (Exception e) {
            log.error("Could not read environment variables", e);
            throw new ConfigException("Could not read environment variables");
        }
    }
}

