/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.portfolio.loanaccount.api;

public interface LoanTransactionApiConstants {

    enum TransactionType {
        disbursement, //
        repayment, //
        waiver, //
        repaymentAtDisbursement, //
        writeOff, //
        markedForRescheduling, //
        recoveryRepayment, //
        waiveCharges, //
        accrual, //
        initiateTransfer, //
        approveTransfer, //
        withdrawTransfer, //
        rejectTransfer, //
        refund, //
        chargePayment, //
        incomePosting, //
        creditBalanceRefund, //
        merchantIssuedRefund, //
        payoutRefund, //
        goodwillCredit, //
        chargeRefund, //
        chargeback, //
        chargeAdjustment, //
        chargeOff, //
        downPayment, //
        reAge, //
        reAmortize, //
        interestPaymentWaiver, //
        accrualActivity, //
        interestRefund, //
        accrualAdjustment, //
        capitalizedIncome, //
        capitalizedIncomeAmortization, //
        capitalizedIncomeAdjustment, //
        contractTermination, //
        capitalizedIncomeAmortizationAdjustment, //
        buyDownFeeAmortization, //
        buyDownFeeAmortizationAdjustment, //
    }

    String TRANSACTION_CLASSIFICATIONID_PARAMNAME = "classificationId";
    String CAPITALIZED_INCOME_CLASSIFICATION_CODE = "capitalized_income_transaction_classification";
    String BUY_DOWN_FEE_CLASSIFICATION_CODE = "buydown_fee_transaction_classification";
}
