/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressFluent;
import io.kubernetes.client.openapi.models.V1IngressFluentImpl;
import java.util.Objects;

public class V1IngressBuilder
extends V1IngressFluentImpl<V1IngressBuilder>
implements VisitableBuilder<V1Ingress, V1IngressBuilder> {
    V1IngressFluent<?> fluent;
    Boolean validationEnabled;

    public V1IngressBuilder() {
        this(true);
    }

    public V1IngressBuilder(Boolean validationEnabled) {
        this(new V1Ingress(), validationEnabled);
    }

    public V1IngressBuilder(V1IngressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1IngressBuilder(V1IngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1Ingress(), validationEnabled);
    }

    public V1IngressBuilder(V1IngressFluent<?> fluent, V1Ingress instance) {
        this(fluent, instance, true);
    }

    public V1IngressBuilder(V1IngressFluent<?> fluent, V1Ingress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public V1IngressBuilder(V1Ingress instance) {
        this(instance, (Boolean)true);
    }

    public V1IngressBuilder(V1Ingress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1Ingress build() {
        V1Ingress buildable = new V1Ingress();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressBuilder that = (V1IngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

