/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ConnectorType {
    JDBC(0, "JDBC"),
    HIVE(1, "HIVE");

    private final int code;
    private final String description;
    private static final Map<Integer, ConnectorType> VALUES_MAP;

    private ConnectorType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConnectorType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, ConnectorType>();
        for (ConnectorType type : ConnectorType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

