/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.models.ShareRequestConditions;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class ShareFileUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final Long length;
    private Long offset;
    private ParallelTransferOptions parallelTransferOptions;
    private ShareRequestConditions requestConditions;

    public ShareFileUploadOptions(Flux<ByteBuffer> dataFlux) {
        StorageImplUtils.assertNotNull((String)"dataFlux", dataFlux);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = null;
    }

    @Deprecated
    public ShareFileUploadOptions(InputStream dataStream, long length) {
        StorageImplUtils.assertNotNull((String)"dataStream", (Object)length);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)0L, (long)Long.MAX_VALUE);
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
    }

    public ShareFileUploadOptions(InputStream dataStream) {
        StorageImplUtils.assertNotNull((String)"dataStream", (Object)dataStream);
        this.dataStream = dataStream;
        this.dataFlux = null;
        this.length = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public Long getLength() {
        return this.length;
    }

    public Long getOffset() {
        return this.offset;
    }

    public ShareFileUploadOptions setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public ShareFileUploadOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public ShareRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ShareFileUploadOptions setRequestConditions(ShareRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }
}

