/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.resource;

import java.sql.SQLException;
import org.apache.dolphinscheduler.tools.resource.MigrateResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
public class MigrateResource {
    public static void main(String[] args) {
        SpringApplication.run(MigrateResource.class, (String[])args);
    }

    @Component
    @Profile(value={"resource"})
    static class MigrateResourceRunner
    implements CommandLineRunner {
        private static final Logger logger = LoggerFactory.getLogger(MigrateResourceRunner.class);
        @Autowired
        private MigrateResourceService migrateResourceService;

        MigrateResourceRunner() {
        }

        public void run(String ... args) throws SQLException {
            String targetTenantCode = args[0];
            logger.info("Moving all unmanaged resources to tenant: {}", (Object)targetTenantCode);
            this.migrateResourceService.migrateResourceOnce(targetTenantCode);
        }
    }
}

