/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HiveLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.HiveAuthenticationType;
import com.azure.resourcemanager.datafactory.models.HiveServerType;
import com.azure.resourcemanager.datafactory.models.HiveThriftTransportProtocol;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Hive")
public final class HiveLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private HiveLinkedServiceTypeProperties innerTypeProperties = new HiveLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HiveLinkedService.class);

    private HiveLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HiveLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public HiveLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HiveLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public HiveLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public HiveLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    public HiveLinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    public HiveServerType serverType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serverType();
    }

    public HiveLinkedService withServerType(HiveServerType serverType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServerType(serverType);
        return this;
    }

    public HiveThriftTransportProtocol thriftTransportProtocol() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().thriftTransportProtocol();
    }

    public HiveLinkedService withThriftTransportProtocol(HiveThriftTransportProtocol thriftTransportProtocol) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withThriftTransportProtocol(thriftTransportProtocol);
        return this;
    }

    public HiveAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public HiveLinkedService withAuthenticationType(HiveAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object serviceDiscoveryMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serviceDiscoveryMode();
    }

    public HiveLinkedService withServiceDiscoveryMode(Object serviceDiscoveryMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServiceDiscoveryMode(serviceDiscoveryMode);
        return this;
    }

    public Object zooKeeperNameSpace() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().zooKeeperNameSpace();
    }

    public HiveLinkedService withZooKeeperNameSpace(Object zooKeeperNameSpace) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withZooKeeperNameSpace(zooKeeperNameSpace);
        return this;
    }

    public Object useNativeQuery() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useNativeQuery();
    }

    public HiveLinkedService withUseNativeQuery(Object useNativeQuery) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseNativeQuery(useNativeQuery);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public HiveLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public HiveLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object httpPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().httpPath();
    }

    public HiveLinkedService withHttpPath(Object httpPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHttpPath(httpPath);
        return this;
    }

    public Object enableSsl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableSsl();
    }

    public HiveLinkedService withEnableSsl(Object enableSsl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableSsl(enableSsl);
        return this;
    }

    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    public HiveLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    public HiveLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowHostnameCNMismatch();
    }

    public HiveLinkedService withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowHostnameCNMismatch(allowHostnameCNMismatch);
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowSelfSignedServerCert();
    }

    public HiveLinkedService withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowSelfSignedServerCert(allowSelfSignedServerCert);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public HiveLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HiveLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HiveLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

