/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimesClient;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeAuthKeysInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeConnectionInfoInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeMonitoringDataInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeResourceInner;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeStatusResponseInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.CreateLinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeListResponse;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeRegenerateKeyParameters;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class IntegrationRuntimesClientImpl
implements IntegrationRuntimesClient {
    private final IntegrationRuntimesService service;
    private final DataFactoryManagementClientImpl client;

    IntegrationRuntimesClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (IntegrationRuntimesService)RestProxy.create(IntegrationRuntimesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IntegrationRuntimeResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IntegrationRuntimeListResponse)res.getValue()).value(), ((IntegrationRuntimeListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IntegrationRuntimeResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IntegrationRuntimeListResponse)res.getValue()).value(), ((IntegrationRuntimeListResponse)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IntegrationRuntimeResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IntegrationRuntimeResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName, Context context) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName, context), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IntegrationRuntimeResourceInner> listByFactory(String resourceGroupName, String factoryName) {
        return new PagedIterable(this.listByFactoryAsync(resourceGroupName, factoryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IntegrationRuntimeResourceInner> listByFactory(String resourceGroupName, String factoryName, Context context) {
        return new PagedIterable(this.listByFactoryAsync(resourceGroupName, factoryName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (integrationRuntime == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntime is required and cannot be null."));
        }
        integrationRuntime.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), ifMatch, integrationRuntime, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (integrationRuntime == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntime is required and cannot be null."));
        }
        integrationRuntime.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), ifMatch, integrationRuntime, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, integrationRuntime, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((IntegrationRuntimeResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime, String ifMatch, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, integrationRuntime, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeResourceInner createOrUpdate(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeResourceInner integrationRuntime) {
        String ifMatch = null;
        return (IntegrationRuntimeResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, factoryName, integrationRuntimeName, integrationRuntime, ifMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeResourceInner> getAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        String ifNoneMatch = null;
        return this.getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((IntegrationRuntimeResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeResourceInner> getWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, String ifNoneMatch, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, ifNoneMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeResourceInner get(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        String ifNoneMatch = null;
        return (IntegrationRuntimeResourceInner)((Object)this.getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, ifNoneMatch, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> updateWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (updateIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateIntegrationRuntimeRequest is required and cannot be null."));
        }
        updateIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), updateIntegrationRuntimeRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeResourceInner>> updateWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (updateIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateIntegrationRuntimeRequest is required and cannot be null."));
        }
        updateIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), updateIntegrationRuntimeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeResourceInner> updateAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest) {
        return this.updateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, updateIntegrationRuntimeRequest).flatMap(res -> Mono.justOrEmpty((Object)((Object)((IntegrationRuntimeResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeResourceInner> updateWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, updateIntegrationRuntimeRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeResourceInner update(String resourceGroupName, String factoryName, String integrationRuntimeName, UpdateIntegrationRuntimeRequest updateIntegrationRuntimeRequest) {
        return (IntegrationRuntimeResourceInner)((Object)this.updateWithResponse(resourceGroupName, factoryName, integrationRuntimeName, updateIntegrationRuntimeRequest, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.deleteWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeStatusResponseInner>> getStatusWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStatus(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeStatusResponseInner>> getStatusWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStatus(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeStatusResponseInner> getStatusAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.getStatusWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeStatusResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeStatusResponseInner> getStatusWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.getStatusWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeStatusResponseInner getStatus(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeStatusResponseInner)this.getStatusWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner>> listOutboundNetworkDependenciesEndpointsWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOutboundNetworkDependenciesEndpoints(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner>> listOutboundNetworkDependenciesEndpointsWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOutboundNetworkDependenciesEndpoints(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner> listOutboundNetworkDependenciesEndpointsAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.listOutboundNetworkDependenciesEndpointsWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner> listOutboundNetworkDependenciesEndpointsWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.listOutboundNetworkDependenciesEndpointsWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner)this.listOutboundNetworkDependenciesEndpointsWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeConnectionInfoInner>> getConnectionInfoWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConnectionInfo(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeConnectionInfoInner>> getConnectionInfoWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConnectionInfo(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeConnectionInfoInner> getConnectionInfoAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.getConnectionInfoWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeConnectionInfoInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeConnectionInfoInner> getConnectionInfoWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.getConnectionInfoWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeConnectionInfoInner getConnectionInfo(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeConnectionInfoInner)this.getConnectionInfoWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeAuthKeysInner>> regenerateAuthKeyWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (regenerateKeyParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyParameters is required and cannot be null."));
        }
        regenerateKeyParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateAuthKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), regenerateKeyParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeAuthKeysInner>> regenerateAuthKeyWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (regenerateKeyParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyParameters is required and cannot be null."));
        }
        regenerateKeyParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateAuthKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), regenerateKeyParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeAuthKeysInner> regenerateAuthKeyAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters) {
        return this.regenerateAuthKeyWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, regenerateKeyParameters).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeAuthKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeAuthKeysInner> regenerateAuthKeyWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters, Context context) {
        return (Response)this.regenerateAuthKeyWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, regenerateKeyParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeAuthKeysInner regenerateAuthKey(String resourceGroupName, String factoryName, String integrationRuntimeName, IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters) {
        return (IntegrationRuntimeAuthKeysInner)this.regenerateAuthKeyWithResponse(resourceGroupName, factoryName, integrationRuntimeName, regenerateKeyParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeAuthKeysInner>> listAuthKeysWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAuthKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeAuthKeysInner>> listAuthKeysWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAuthKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeAuthKeysInner> listAuthKeysAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.listAuthKeysWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeAuthKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeAuthKeysInner> listAuthKeysWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.listAuthKeysWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeAuthKeysInner listAuthKeys(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeAuthKeysInner)this.listAuthKeysWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner> beginStartAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IntegrationRuntimeStatusResponseInner.class), (Type)((Object)IntegrationRuntimeStatusResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner> beginStartAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IntegrationRuntimeStatusResponseInner.class), (Type)((Object)IntegrationRuntimeStatusResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner> beginStart(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginStartAsync(resourceGroupName, factoryName, integrationRuntimeName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IntegrationRuntimeStatusResponseInner>, IntegrationRuntimeStatusResponseInner> beginStart(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginStartAsync(resourceGroupName, factoryName, integrationRuntimeName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeStatusResponseInner> startAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginStartAsync(resourceGroupName, factoryName, integrationRuntimeName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeStatusResponseInner> startAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginStartAsync(resourceGroupName, factoryName, integrationRuntimeName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeStatusResponseInner start(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeStatusResponseInner)this.startAsync(resourceGroupName, factoryName, integrationRuntimeName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeStatusResponseInner start(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (IntegrationRuntimeStatusResponseInner)this.startAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginStopAsync(resourceGroupName, factoryName, integrationRuntimeName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginStopAsync(resourceGroupName, factoryName, integrationRuntimeName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.beginStopAsync(resourceGroupName, factoryName, integrationRuntimeName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return this.beginStopAsync(resourceGroupName, factoryName, integrationRuntimeName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.stopAsync(resourceGroupName, factoryName, integrationRuntimeName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        this.stopAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> syncCredentialsWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.syncCredentials(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> syncCredentialsWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.syncCredentials(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> syncCredentialsAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.syncCredentialsWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> syncCredentialsWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.syncCredentialsWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void syncCredentials(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.syncCredentialsWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeMonitoringDataInner>> getMonitoringDataWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMonitoringData(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeMonitoringDataInner>> getMonitoringDataWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMonitoringData(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeMonitoringDataInner> getMonitoringDataAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.getMonitoringDataWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeMonitoringDataInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeMonitoringDataInner> getMonitoringDataWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.getMonitoringDataWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeMonitoringDataInner getMonitoringData(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return (IntegrationRuntimeMonitoringDataInner)this.getMonitoringDataWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> upgradeWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.upgrade(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> upgradeWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.upgrade(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> upgradeAsync(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        return this.upgradeWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> upgradeWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, Context context) {
        return (Response)this.upgradeWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upgrade(String resourceGroupName, String factoryName, String integrationRuntimeName) {
        this.upgradeWithResponse(resourceGroupName, factoryName, integrationRuntimeName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removeLinksWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (linkedIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedIntegrationRuntimeRequest is required and cannot be null."));
        }
        linkedIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeLinks(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), linkedIntegrationRuntimeRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removeLinksWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (linkedIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedIntegrationRuntimeRequest is required and cannot be null."));
        }
        linkedIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removeLinks(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), linkedIntegrationRuntimeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> removeLinksAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest) {
        return this.removeLinksWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, linkedIntegrationRuntimeRequest).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeLinksWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest, Context context) {
        return (Response)this.removeLinksWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, linkedIntegrationRuntimeRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeLinks(String resourceGroupName, String factoryName, String integrationRuntimeName, LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest) {
        this.removeLinksWithResponse(resourceGroupName, factoryName, integrationRuntimeName, linkedIntegrationRuntimeRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeStatusResponseInner>> createLinkedIntegrationRuntimeWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (createLinkedIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createLinkedIntegrationRuntimeRequest is required and cannot be null."));
        }
        createLinkedIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createLinkedIntegrationRuntime(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), createLinkedIntegrationRuntimeRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeStatusResponseInner>> createLinkedIntegrationRuntimeWithResponseAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (createLinkedIntegrationRuntimeRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter createLinkedIntegrationRuntimeRequest is required and cannot be null."));
        }
        createLinkedIntegrationRuntimeRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createLinkedIntegrationRuntime(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, integrationRuntimeName, this.client.getApiVersion(), createLinkedIntegrationRuntimeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeStatusResponseInner> createLinkedIntegrationRuntimeAsync(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest) {
        return this.createLinkedIntegrationRuntimeWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, createLinkedIntegrationRuntimeRequest).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeStatusResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeStatusResponseInner> createLinkedIntegrationRuntimeWithResponse(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest, Context context) {
        return (Response)this.createLinkedIntegrationRuntimeWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, createLinkedIntegrationRuntimeRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeStatusResponseInner createLinkedIntegrationRuntime(String resourceGroupName, String factoryName, String integrationRuntimeName, CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest) {
        return (IntegrationRuntimeStatusResponseInner)this.createLinkedIntegrationRuntimeWithResponse(resourceGroupName, factoryName, integrationRuntimeName, createLinkedIntegrationRuntimeRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IntegrationRuntimeResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IntegrationRuntimeListResponse)res.getValue()).value(), ((IntegrationRuntimeListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IntegrationRuntimeResourceInner>> listByFactoryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IntegrationRuntimeListResponse)res.getValue()).value(), ((IntegrationRuntimeListResponse)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface IntegrationRuntimesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeListResponse>> listByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") IntegrationRuntimeResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") UpdateIntegrationRuntimeRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/getStatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeStatusResponseInner>> getStatus(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/outboundNetworkDependenciesEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponseInner>> listOutboundNetworkDependenciesEndpoints(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/getConnectionInfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeConnectionInfoInner>> getConnectionInfo(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/regenerateAuthKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeAuthKeysInner>> regenerateAuthKey(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") IntegrationRuntimeRegenerateKeyParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/listAuthKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeAuthKeysInner>> listAuthKeys(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/syncCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> syncCredentials(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/monitoringData")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeMonitoringDataInner>> getMonitoringData(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/upgrade")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> upgrade(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/removeLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> removeLinks(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") LinkedIntegrationRuntimeRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/linkedIntegrationRuntime")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeStatusResponseInner>> createLinkedIntegrationRuntime(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="integrationRuntimeName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") CreateLinkedIntegrationRuntimeRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeListResponse>> listByFactoryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

