/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.AccessPolicyResponse;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.Factory;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryUpdateParameters;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenRequest;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenResponse;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import com.azure.resourcemanager.datafactory.models.UserAccessPolicy;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class FactoryImpl
implements Factory,
Factory.Definition,
Factory.Update {
    private FactoryInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String createIfMatch;
    private FactoryUpdateParameters updateFactoryUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public FactoryIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, Object> additionalProperties() {
        Map<String, Object> inner = this.innerModel().additionalProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime createTime() {
        return this.innerModel().createTime();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public PurviewConfiguration purviewConfiguration() {
        return this.innerModel().purviewConfiguration();
    }

    @Override
    public FactoryRepoConfiguration repoConfiguration() {
        return this.innerModel().repoConfiguration();
    }

    @Override
    public Map<String, GlobalParameterSpecification> globalParameters() {
        Map<String, GlobalParameterSpecification> inner = this.innerModel().globalParameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public EncryptionConfiguration encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FactoryInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public FactoryImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Factory create() {
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public Factory create(Context context) {
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    FactoryImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new FactoryInner();
        this.serviceManager = serviceManager;
        this.factoryName = name;
        this.createIfMatch = null;
    }

    @Override
    public FactoryImpl update() {
        this.updateFactoryUpdateParameters = new FactoryUpdateParameters();
        return this;
    }

    @Override
    public Factory apply() {
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().updateWithResponse(this.resourceGroupName, this.factoryName, this.updateFactoryUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Factory apply(Context context) {
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().updateWithResponse(this.resourceGroupName, this.factoryName, this.updateFactoryUpdateParameters, context).getValue());
        return this;
    }

    FactoryImpl(FactoryInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
    }

    @Override
    public Factory refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().getByResourceGroupWithResponse(this.resourceGroupName, this.factoryName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public Factory refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (FactoryInner)((Object)this.serviceManager.serviceClient().getFactories().getByResourceGroupWithResponse(this.resourceGroupName, this.factoryName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public Response<GitHubAccessTokenResponse> getGitHubAccessTokenWithResponse(GitHubAccessTokenRequest gitHubAccessTokenRequest, Context context) {
        return this.serviceManager.factories().getGitHubAccessTokenWithResponse(this.resourceGroupName, this.factoryName, gitHubAccessTokenRequest, context);
    }

    @Override
    public GitHubAccessTokenResponse getGitHubAccessToken(GitHubAccessTokenRequest gitHubAccessTokenRequest) {
        return this.serviceManager.factories().getGitHubAccessToken(this.resourceGroupName, this.factoryName, gitHubAccessTokenRequest);
    }

    @Override
    public Response<AccessPolicyResponse> getDataPlaneAccessWithResponse(UserAccessPolicy policy, Context context) {
        return this.serviceManager.factories().getDataPlaneAccessWithResponse(this.resourceGroupName, this.factoryName, policy, context);
    }

    @Override
    public AccessPolicyResponse getDataPlaneAccess(UserAccessPolicy policy) {
        return this.serviceManager.factories().getDataPlaneAccess(this.resourceGroupName, this.factoryName, policy);
    }

    @Override
    public FactoryImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public FactoryImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public FactoryImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateFactoryUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public FactoryImpl withIdentity(FactoryIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateFactoryUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public FactoryImpl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.innerModel().withAdditionalProperties(additionalProperties);
        return this;
    }

    @Override
    public FactoryImpl withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        this.innerModel().withPurviewConfiguration(purviewConfiguration);
        return this;
    }

    @Override
    public FactoryImpl withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.innerModel().withRepoConfiguration(repoConfiguration);
        return this;
    }

    @Override
    public FactoryImpl withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        this.innerModel().withGlobalParameters(globalParameters);
        return this;
    }

    @Override
    public FactoryImpl withEncryption(EncryptionConfiguration encryption) {
        this.innerModel().withEncryption(encryption);
        return this;
    }

    @Override
    public FactoryImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateFactoryUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public FactoryImpl withIfMatch(String ifMatch) {
        this.createIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

