/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.gcs;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.apache.dolphinscheduler.plugin.storage.gcs.GcsStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.gcs.GcsStorageProperties;

@AutoService(value={StorageOperatorFactory.class})
public class GcsStorageOperatorFactory
implements StorageOperatorFactory {
    public StorageOperator createStorageOperate() {
        GcsStorageProperties gcsStorageProperties = this.getGcsStorageProperties();
        return new GcsStorageOperator(gcsStorageProperties);
    }

    public GcsStorageProperties getGcsStorageProperties() {
        return GcsStorageProperties.builder().resourceUploadPath(PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler")).credential(PropertyUtils.getString((String)"resource.google.cloud.storage.credential")).bucketName(PropertyUtils.getString((String)"resource.google.cloud.storage.bucket.name")).build();
    }

    public StorageType getStorageOperate() {
        return StorageType.GCS;
    }
}

