/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasParent;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsCreating;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SqlDatabase;

public interface SqlDatabaseThreatDetectionPolicy
extends ExternalChildResource<SqlDatabaseThreatDetectionPolicy, SqlDatabase>,
HasParent<SqlDatabase>,
HasInnerModel<DatabaseSecurityAlertPolicyInner>,
HasResourceGroup,
Refreshable<SqlDatabaseThreatDetectionPolicy>,
Updatable<Update> {
    public Region region();

    public String kind();

    public SecurityAlertPolicyState currentState();

    public String disabledAlerts();

    public String emailAddresses();

    public boolean emailAccountAdmins();

    public String storageEndpoint();

    public String storageAccountAccessKey();

    public int retentionDays();

    public boolean isDefaultSecurityAlertPolicy();

    public static interface UpdateStages {

        public static interface WithEmailToAccountAdmins {
            public Update withEmailToAccountAdmins();

            public Update withoutEmailToAccountAdmins();
        }

        public static interface WithRetentionDays {
            public Update withRetentionDays(int var1);
        }

        public static interface WithEmailAddresses {
            public Update withEmailAddresses(String var1);
        }

        public static interface WithAlertsFilter {
            public Update withAlertsFilter(String var1);
        }

        public static interface WithStorageAccountAccessKey {
            public Update withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public Update withStorageEndpoint(String var1);
        }

        public static interface WithSecurityAlertPolicyState {
            public Update withPolicyEnabled();

            public Update withPolicyDisabled();

            public Update withPolicyNew();

            public Update withDefaultSecurityAlertPolicy();
        }
    }

    public static interface Update
    extends UpdateStages.WithSecurityAlertPolicyState,
    UpdateStages.WithStorageEndpoint,
    UpdateStages.WithStorageAccountAccessKey,
    UpdateStages.WithAlertsFilter,
    UpdateStages.WithEmailAddresses,
    UpdateStages.WithRetentionDays,
    UpdateStages.WithEmailToAccountAdmins,
    Appliable<SqlDatabaseThreatDetectionPolicy> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithStorageEndpoint,
        WithStorageAccountAccessKey,
        WithAlertsFilter,
        WithEmailAddresses,
        WithRetentionDays,
        WithEmailToAccountAdmins,
        Creatable<SqlDatabaseThreatDetectionPolicy> {
        }

        public static interface WithEmailToAccountAdmins {
            public WithCreate withEmailToAccountAdmins();

            public WithCreate withoutEmailToAccountAdmins();
        }

        public static interface WithRetentionDays {
            public WithCreate withRetentionDays(int var1);
        }

        public static interface WithEmailAddresses {
            public WithCreate withEmailAddresses(String var1);
        }

        public static interface WithAlertsFilter {
            public WithCreate withAlertsFilter(String var1);
        }

        public static interface WithStorageAccountAccessKey {
            public WithCreate withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public WithStorageAccountAccessKey withStorageEndpoint(String var1);
        }

        public static interface WithSecurityAlertPolicyState {
            public WithStorageEndpoint withPolicyEnabled();

            public WithCreate withPolicyDisabled();

            public WithStorageEndpoint withPolicyNew();

            public WithCreate withDefaultSecurityAlertPolicy();
        }

        public static interface Blank
        extends WithSecurityAlertPolicyState {
        }
    }

    public static interface SqlDatabaseThreatDetectionPolicyDefinition
    extends DefinitionStages.Blank,
    DefinitionStages.WithSecurityAlertPolicyState,
    DefinitionStages.WithStorageEndpoint,
    DefinitionStages.WithStorageAccountAccessKey,
    DefinitionStages.WithAlertsFilter,
    DefinitionStages.WithEmailAddresses,
    DefinitionStages.WithRetentionDays,
    DefinitionStages.WithEmailToAccountAdmins,
    DefinitionStages.WithCreate {
    }

    public static interface SqlDatabaseThreatDetectionPolicyOperations
    extends SupportsCreating<DefinitionStages.Blank> {
        public DefinitionStages.Blank defineThreatDetectionPolicy(String var1);

        public SqlDatabaseThreatDetectionPolicy getThreatDetectionPolicy();
    }
}

