/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionActivityInner;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionInner;
import com.azure.resourcemanager.sql.implementation.TransparentDataEncryptionActivityImpl;
import com.azure.resourcemanager.sql.models.TransparentDataEncryption;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionActivity;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class TransparentDataEncryptionImpl
extends RefreshableWrapperImpl<TransparentDataEncryptionInner, TransparentDataEncryption>
implements TransparentDataEncryption {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected TransparentDataEncryptionImpl(String resourceGroupName, String sqlServerName, TransparentDataEncryptionInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((TransparentDataEncryptionInner)((Object)this.innerModel())).id());
    }

    public String name() {
        return ((TransparentDataEncryptionInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((TransparentDataEncryptionInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public TransparentDataEncryptionStatus status() {
        return ((TransparentDataEncryptionInner)((Object)this.innerModel())).status();
    }

    @Override
    public TransparentDataEncryption updateStatus(TransparentDataEncryptionStatus transparentDataEncryptionState) {
        ((TransparentDataEncryptionInner)((Object)this.innerModel())).withStatus(transparentDataEncryptionState);
        TransparentDataEncryptionInner transparentDataEncryptionInner = (TransparentDataEncryptionInner)((Object)((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdateWithResponse(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT, new TransparentDataEncryptionInner().withStatus(transparentDataEncryptionState), Context.NONE).getValue());
        this.setInner((Object)transparentDataEncryptionInner);
        return this;
    }

    @Override
    public Mono<TransparentDataEncryption> updateStatusAsync(TransparentDataEncryptionStatus transparentDataEncryptionState) {
        TransparentDataEncryptionImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.databaseName(), TransparentDataEncryptionName.CURRENT, new TransparentDataEncryptionInner().withStatus(transparentDataEncryptionState)).map(transparentDataEncryptionInner -> {
            self.setInner(transparentDataEncryptionInner);
            return self;
        });
    }

    @Override
    public List<TransparentDataEncryptionActivity> listActivities() {
        ArrayList<TransparentDataEncryptionActivityImpl> transparentDataEncryptionActivities = new ArrayList<TransparentDataEncryptionActivityImpl>();
        PagedIterable<TransparentDataEncryptionActivityInner> transparentDataEncryptionActivityInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptionActivities().listByConfiguration(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT);
        for (TransparentDataEncryptionActivityInner transparentDataEncryptionActivityInner : transparentDataEncryptionActivityInners) {
            transparentDataEncryptionActivities.add(new TransparentDataEncryptionActivityImpl(transparentDataEncryptionActivityInner));
        }
        return Collections.unmodifiableList(transparentDataEncryptionActivities);
    }

    @Override
    public PagedFlux<TransparentDataEncryptionActivity> listActivitiesAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptionActivities().listByConfigurationAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT), TransparentDataEncryptionActivityImpl::new);
    }

    protected Mono<TransparentDataEncryptionInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT);
    }
}

