/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryInner;
import com.azure.resourcemanager.datafactory.models.AccessPolicyResponse;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenRequest;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenResponse;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import com.azure.resourcemanager.datafactory.models.UserAccessPolicy;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Factory {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public FactoryIdentity identity();

    public String etag();

    public Map<String, Object> additionalProperties();

    public String provisioningState();

    public OffsetDateTime createTime();

    public String version();

    public PurviewConfiguration purviewConfiguration();

    public FactoryRepoConfiguration repoConfiguration();

    public Map<String, GlobalParameterSpecification> globalParameters();

    public EncryptionConfiguration encryption();

    public PublicNetworkAccess publicNetworkAccess();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public FactoryInner innerModel();

    public Update update();

    public Factory refresh();

    public Factory refresh(Context var1);

    public Response<GitHubAccessTokenResponse> getGitHubAccessTokenWithResponse(GitHubAccessTokenRequest var1, Context var2);

    public GitHubAccessTokenResponse getGitHubAccessToken(GitHubAccessTokenRequest var1);

    public Response<AccessPolicyResponse> getDataPlaneAccessWithResponse(UserAccessPolicy var1, Context var2);

    public AccessPolicyResponse getDataPlaneAccess(UserAccessPolicy var1);

    public static interface UpdateStages {

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(FactoryIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithPublicNetworkAccess {
        public Factory apply();

        public Factory apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(EncryptionConfiguration var1);
        }

        public static interface WithGlobalParameters {
            public WithCreate withGlobalParameters(Map<String, GlobalParameterSpecification> var1);
        }

        public static interface WithRepoConfiguration {
            public WithCreate withRepoConfiguration(FactoryRepoConfiguration var1);
        }

        public static interface WithPurviewConfiguration {
            public WithCreate withPurviewConfiguration(PurviewConfiguration var1);
        }

        public static interface WithAdditionalProperties {
            public WithCreate withAdditionalProperties(Map<String, Object> var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(FactoryIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithAdditionalProperties,
        WithPurviewConfiguration,
        WithRepoConfiguration,
        WithGlobalParameters,
        WithEncryption,
        WithPublicNetworkAccess,
        WithIfMatch {
            public Factory create();

            public Factory create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

