/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class KmsUploadDemo {
    private static COSClient cosClient = KmsUploadDemo.createCOSClient();
    private static String bucketName = "mybucket-12500000000";
    private static String key = "aaa/bbb.txt";
    private static String kmsKeyId = "your-kms-key-id";
    private static String encryptionContext = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());

    public static void main(String[] args) {
        try {
            KmsUploadDemo.simpleUploadWithKmsMeta();
            KmsUploadDemo.simpledownloadWithKmsMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static COSClient createCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials("COS_SECRETID", "COS_SECRETKEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        return cosclient;
    }

    private static void simpleUploadWithKmsMeta() {
        File localFile = new File("/test.log");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        SSECOSKeyManagementParams ssecosKeyManagementParams = new SSECOSKeyManagementParams(kmsKeyId, encryptionContext);
        putObjectRequest.setSSECOSKeyManagementParams(ssecosKeyManagementParams);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        try {
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            String crc64 = putObjectResult.getCrc64Ecma();
            System.out.println("finish upload, crc64:" + crc64);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void simpledownloadWithKmsMeta() throws IOException {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        try (COSObject cosObject = null;){
            cosObject = cosClient.getObject(getObjectRequest);
            COSObjectInputStream cosObjectInputStream = cosObject.getObjectContent();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(cosObjectInputStream));
            System.out.println(bufferedReader.readLine());
        }
    }

    private static void multipartUploadWithKmsMeta() {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
        SSECOSKeyManagementParams ssecosKeyManagementParams = new SSECOSKeyManagementParams(kmsKeyId, encryptionContext);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        initiateMultipartUploadRequest.setSSECOSKeyManagementParams(ssecosKeyManagementParams);
        try {
            InitiateMultipartUploadResult initiateMultipartUploadResult = cosClient.initiateMultipartUpload(initiateMultipartUploadRequest);
            LinkedList<PartETag> partETags = new LinkedList<PartETag>();
            for (int i = 0; i < 2; ++i) {
                byte[] data = new byte[0x100000];
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(key);
                uploadPartRequest.setUploadId(initiateMultipartUploadResult.getUploadId());
                uploadPartRequest.setInputStream(new ByteArrayInputStream(data));
                uploadPartRequest.setPartSize(data.length);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = cosClient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                partETags.add(partETag);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, initiateMultipartUploadResult.getUploadId(), partETags);
            CompleteMultipartUploadResult completeResult = cosClient.completeMultipartUpload(completeMultipartUploadRequest);
            System.out.println("finsh multipart upload, reqId:" + completeResult.getRequestId());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    private static void copyObjectWithKmsMeta() {
        Region srcBucketRegion = new Region("ap-guangzhou");
        String srcBucketName = "mybucket-12500000000";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "mybucket-12500000000";
        String destKey = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        copyObjectRequest.setSSECOSKeyManagementParams(new SSECOSKeyManagementParams(kmsKeyId, encryptionContext));
        try {
            CopyObjectResult copyObjectResult = cosClient.copyObject(copyObjectRequest);
            String crc64 = copyObjectResult.getCrc64Ecma();
            System.out.println("finish copy object, crc64:" + crc64);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }
}

