/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.future;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.IRpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFuture {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseFuture.class);
    private static final ConcurrentHashMap<Long, ResponseFuture> FUTURE_TABLE = new ConcurrentHashMap();
    private final long opaque;
    private final long timeoutMillis;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long beginTimestamp = System.currentTimeMillis();
    private IRpcResponse iRpcResponse;
    private volatile boolean sendOk = true;
    private Throwable cause;

    public ResponseFuture(long opaque, long timeoutMillis) {
        this.opaque = opaque;
        this.timeoutMillis = timeoutMillis;
        FUTURE_TABLE.put(opaque, this);
    }

    public IRpcResponse waitResponse() throws InterruptedException {
        if (!this.latch.await(this.timeoutMillis, TimeUnit.MILLISECONDS)) {
            log.warn("Wait response in {}/ms timeout, request id {}", (Object)this.timeoutMillis, (Object)this.opaque);
        }
        return this.iRpcResponse;
    }

    public void putResponse(IRpcResponse iRpcResponse) {
        this.iRpcResponse = iRpcResponse;
        this.latch.countDown();
        FUTURE_TABLE.remove(this.opaque);
    }

    public static ResponseFuture getFuture(long opaque) {
        return FUTURE_TABLE.get(opaque);
    }

    public boolean isTimeout() {
        long diff = System.currentTimeMillis() - this.beginTimestamp;
        return diff > this.timeoutMillis;
    }

    public boolean isSendOK() {
        return this.sendOk;
    }

    public void setSendOk(boolean sendOk) {
        this.sendOk = sendOk;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Generated
    public String toString() {
        return "ResponseFuture(opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", latch=" + this.latch + ", beginTimestamp=" + this.beginTimestamp + ", iRpcResponse=" + this.getIRpcResponse() + ", sendOk=" + this.isSendOK() + ", cause=" + this.getCause() + ")";
    }

    @Generated
    public IRpcResponse getIRpcResponse() {
        return this.iRpcResponse;
    }

    @Generated
    public void setIRpcResponse(IRpcResponse iRpcResponse) {
        this.iRpcResponse = iRpcResponse;
    }
}

