/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.RoleDefinitionsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleDefinitionInner;
import com.azure.resourcemanager.authorization.implementation.RoleDefinitionImpl;
import com.azure.resourcemanager.authorization.models.RoleDefinition;
import com.azure.resourcemanager.authorization.models.RoleDefinitions;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class RoleDefinitionsImpl
extends ReadableWrappersImpl<RoleDefinition, RoleDefinitionImpl, RoleDefinitionInner>
implements RoleDefinitions {
    private final AuthorizationManager manager;

    public RoleDefinitionsImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    protected RoleDefinitionImpl wrapModel(RoleDefinitionInner roleDefinitionInner) {
        if (roleDefinitionInner == null) {
            return null;
        }
        return new RoleDefinitionImpl(roleDefinitionInner, this.manager());
    }

    public RoleDefinition getById(String objectId) {
        return (RoleDefinition)this.getByIdAsync(objectId).block();
    }

    public Mono<RoleDefinition> getByIdAsync(String id) {
        return this.inner().getByIdAsync(id).map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public RoleDefinition getByScope(String scope, String name) {
        return (RoleDefinition)this.getByScopeAsync(scope, name).block();
    }

    @Override
    public Mono<RoleDefinition> getByScopeAsync(String scope, String name) {
        return this.inner().getAsync(scope, name).map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public RoleDefinition getByScopeAndRoleName(String scope, String roleName) {
        return (RoleDefinition)this.getByScopeAndRoleNameAsync(scope, roleName).block();
    }

    @Override
    public PagedFlux<RoleDefinition> listByScopeAsync(String scope) {
        return PagedConverter.mapPage(this.inner().listAsync(scope, null), roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    @Override
    public PagedIterable<RoleDefinition> listByScope(String scope) {
        return this.wrapList(this.inner().list(scope));
    }

    @Override
    public Mono<RoleDefinition> getByScopeAndRoleNameAsync(String scope, String roleName) {
        return this.inner().listAsync(scope, String.format("roleName eq '%s'", roleName)).singleOrEmpty().map(roleDefinitionInner -> new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInner, this.manager()));
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public RoleDefinitionsClient inner() {
        return this.manager().roleServiceClient().getRoleDefinitions();
    }
}

