/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceController;
import org.apache.dolphinscheduler.extract.master.transportor.TaskGroupSlotAcquireSuccessNotifyRequest;
import org.apache.dolphinscheduler.extract.master.transportor.TaskGroupSlotAcquireSuccessNotifyResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceControllerImpl
implements ITaskInstanceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceControllerImpl.class);
    @Autowired
    private IWorkflowRepository workflowExecutionRunnableMemoryRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskGroupSlotAcquireSuccessNotifyResponse notifyTaskGroupSlotAcquireSuccess(TaskGroupSlotAcquireSuccessNotifyRequest taskGroupSlotAcquireSuccessNotifyRequest) {
        log.info("Received TaskGroupSlotAcquireSuccessRequest request{}", (Object)taskGroupSlotAcquireSuccessNotifyRequest);
        try {
            int workflowInstanceId = taskGroupSlotAcquireSuccessNotifyRequest.getWorkflowInstanceId();
            int taskInstanceId = taskGroupSlotAcquireSuccessNotifyRequest.getTaskInstanceId();
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)workflowInstanceId, (Integer)taskInstanceId);
            IWorkflowExecutionRunnable workflowExecutionRunnable = this.workflowExecutionRunnableMemoryRepository.get(workflowInstanceId);
            if (workflowExecutionRunnable == null) {
                log.warn("cannot find WorkflowExecuteRunnable: {}, no need to Wakeup task", (Object)workflowInstanceId);
                TaskGroupSlotAcquireSuccessNotifyResponse taskGroupSlotAcquireSuccessNotifyResponse = TaskGroupSlotAcquireSuccessNotifyResponse.failed((String)("cannot find WorkflowExecuteRunnable: " + workflowInstanceId));
                return taskGroupSlotAcquireSuccessNotifyResponse;
            }
            ITaskExecutionRunnable taskExecutionRunnable = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph().getTaskExecutionRunnableById(taskInstanceId);
            if (taskExecutionRunnable == null) {
                log.warn("Cannot find TaskExecutionRunnable: {}, no need to Wakeup task", (Object)taskInstanceId);
                TaskGroupSlotAcquireSuccessNotifyResponse taskGroupSlotAcquireSuccessNotifyResponse = TaskGroupSlotAcquireSuccessNotifyResponse.failed((String)("Cannot find TaskExecutionRunnable: " + taskInstanceId));
                return taskGroupSlotAcquireSuccessNotifyResponse;
            }
            workflowExecutionRunnable.getWorkflowEventBus().publish(TaskDispatchLifecycleEvent.of(taskExecutionRunnable));
            log.info("Success Wakeup TaskInstance: {}", (Object)taskInstanceId);
            TaskGroupSlotAcquireSuccessNotifyResponse taskGroupSlotAcquireSuccessNotifyResponse = TaskGroupSlotAcquireSuccessNotifyResponse.success();
            return taskGroupSlotAcquireSuccessNotifyResponse;
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

