/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.server.master.cluster.MasterSlotManager;
import org.apache.dolphinscheduler.server.master.config.CommandFetchStrategy;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.command.ICommandFetcher;
import org.apache.dolphinscheduler.server.master.engine.command.IdSlotBasedCommandFetcher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommandFetcherConfiguration {
    @Bean
    public ICommandFetcher commandFetcher(MasterConfig masterConfig, MasterSlotManager masterSlotManager, CommandDao commandDao) {
        CommandFetchStrategy commandFetchStrategy = (CommandFetchStrategy)Preconditions.checkNotNull((Object)masterConfig.getCommandFetchStrategy(), (Object)"command fetch strategy is null");
        switch (commandFetchStrategy.getType()) {
            case ID_SLOT_BASED: {
                CommandFetchStrategy.IdSlotBasedFetchConfig idSlotBasedFetchConfig = (CommandFetchStrategy.IdSlotBasedFetchConfig)commandFetchStrategy.getConfig();
                return new IdSlotBasedCommandFetcher(idSlotBasedFetchConfig, masterSlotManager, commandDao);
            }
        }
        throw new IllegalArgumentException("unsupported command fetch strategy type: " + (Object)((Object)commandFetchStrategy.getType()));
    }
}

