/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.utils.BinaryUtil;
import java.io.UnsupportedEncodingException;
import javax.crypto.Mac;

public class HmacSHA1Signature
extends ServiceSignature {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ALGORITHM = "HmacSHA1";
    private static final String VERSION = "1";
    private static final Object LOCK = new Object();
    private static Mac macInstance;

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String computeSignature(String key, String data) {
        try {
            byte[] signData = this.sign(key.getBytes(DEFAULT_ENCODING), data.getBytes(DEFAULT_ENCODING), macInstance, LOCK, ALGORITHM);
            return BinaryUtil.toBase64String(signData);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported algorithm: UTF-8", ex);
        }
    }

    @Override
    public byte[] computeHash(byte[] key, byte[] data) {
        return this.sign(key, data, macInstance, LOCK, ALGORITHM);
    }
}

