/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.OracleUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PreparedStatementPool {
    private static final Log LOG = LogFactory.getLog(PreparedStatementPool.class);
    private final LRUCache map;
    private final DruidAbstractDataSource dataSource;

    public PreparedStatementPool(DruidConnectionHolder holder) {
        this.dataSource = holder.getDataSource();
        int initCapacity = holder.getDataSource().getMaxPoolPreparedStatementPerConnectionSize();
        if (initCapacity <= 0) {
            initCapacity = 16;
        }
        this.map = new LRUCache(initCapacity);
    }

    public PreparedStatementHolder get(DruidPooledPreparedStatement.PreparedStatementKey key) throws SQLException {
        PreparedStatementHolder holder = (PreparedStatementHolder)this.map.get(key);
        if (holder != null) {
            if (holder.isInUse() && !this.dataSource.isSharePreparedStatements()) {
                return null;
            }
            holder.incrementHitCount();
            this.dataSource.incrementCachedPreparedStatementHitCount();
            if (holder.isEnterOracleImplicitCache()) {
                OracleUtils.exitImplicitCacheToActive(holder.statement);
            }
        } else {
            this.dataSource.incrementCachedPreparedStatementMissCount();
        }
        return holder;
    }

    public void remove(PreparedStatementHolder stmtHolder) throws SQLException {
        if (stmtHolder == null) {
            return;
        }
        this.map.remove(stmtHolder.key);
        this.closeRemovedStatement(stmtHolder);
    }

    public void put(PreparedStatementHolder stmtHolder) throws SQLException {
        PreparedStatement stmt = stmtHolder.statement;
        if (stmt == null) {
            return;
        }
        if (this.dataSource.isOracle() && this.dataSource.isUseOracleImplicitCache()) {
            OracleUtils.enterImplicitCache(stmt);
            stmtHolder.setEnterOracleImplicitCache(true);
        } else {
            stmtHolder.setEnterOracleImplicitCache(false);
        }
        PreparedStatementHolder oldStmtHolder = this.map.put(stmtHolder.key, stmtHolder);
        if (oldStmtHolder == stmtHolder) {
            return;
        }
        if (oldStmtHolder != null) {
            oldStmtHolder.setPooling(false);
            this.closeRemovedStatement(oldStmtHolder);
        } else if (stmtHolder.getHitCount() == 0) {
            this.dataSource.incrementCachedPreparedStatementCount();
        }
        stmtHolder.setPooling(true);
        if (LOG.isDebugEnabled()) {
            PreparedStatementProxy stmtProxy;
            String message = null;
            message = stmtHolder.statement instanceof PreparedStatementProxy ? ((stmtProxy = (PreparedStatementProxy)stmtHolder.statement) instanceof CallableStatementProxy ? "{conn-" + stmtProxy.getConnectionProxy().getId() + ", cstmt-" + stmtProxy.getId() + "} enter cache" : "{conn-" + stmtProxy.getConnectionProxy().getId() + ", pstmt-" + stmtProxy.getId() + "} enter cache") : "stmt enter cache";
            LOG.debug(message);
        }
    }

    public void clear() {
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.closeRemovedStatement((PreparedStatementHolder)entry.getValue());
            iter.remove();
        }
    }

    public void closeRemovedStatement(PreparedStatementHolder holder) {
        if (LOG.isDebugEnabled()) {
            PreparedStatementProxy stmtProxy;
            String message = null;
            message = holder.statement instanceof PreparedStatementProxy ? ((stmtProxy = (PreparedStatementProxy)holder.statement) instanceof CallableStatementProxy ? "{conn-" + stmtProxy.getConnectionProxy().getId() + ", cstmt-" + stmtProxy.getId() + "} exit cache" : "{conn-" + stmtProxy.getConnectionProxy().getId() + ", pstmt-" + stmtProxy.getId() + "} exit cache") : "stmt exit cache";
            LOG.debug(message);
        }
        holder.setPooling(false);
        if (holder.isInUse()) {
            return;
        }
        if (holder.isEnterOracleImplicitCache()) {
            try {
                OracleUtils.exitImplicitCacheToClose(holder.statement);
            }
            catch (Exception ex) {
                LOG.error("exitImplicitCacheToClose error", ex);
            }
        }
        this.dataSource.closePreapredStatement(holder);
    }

    public Map<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> getMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    public class LRUCache
    extends LinkedHashMap<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> {
        private static final long serialVersionUID = 1L;

        public LRUCache(int maxSize) {
            super(maxSize, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > PreparedStatementPool.this.dataSource.getMaxPoolPreparedStatementPerConnectionSize();
            if (remove) {
                PreparedStatementPool.this.closeRemovedStatement(eldest.getValue());
            }
            return remove;
        }
    }

    public static enum MethodType {
        M1,
        M2,
        M3,
        M4,
        M5,
        M6,
        Precall_1,
        Precall_2,
        Precall_3;

    }
}

